/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configdefinition;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SpecialtokensConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "385d8b4566e898e31fd9fbde4e9c8b65";
    public static final String CONFIG_DEF_NAME = "specialtokens";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.configdefinition";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.configdefinition", "makefsaPath string default=\"bin/vespa-makefsa\"", "tokenlist[].name string", "tokenlist[].tokens[].token string", "tokenlist[].tokens[].replace string default=\"\""};
    private final StringNode makefsaPath;
    private final InnerNodeVector<Tokenlist> tokenlist;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public SpecialtokensConfig(Builder builder) {
        this(builder, true);
    }

    private SpecialtokensConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for specialtokens must be initialized: " + builder.__uninitialized);
        }
        this.makefsaPath = builder.makefsaPath == null ? new StringNode("bin/vespa-makefsa") : new StringNode(builder.makefsaPath);
        this.tokenlist = Tokenlist.createVector(builder.tokenlist);
    }

    public String makefsaPath() {
        return this.makefsaPath.value();
    }

    public List<Tokenlist> tokenlist() {
        return this.tokenlist;
    }

    public Tokenlist tokenlist(int i) {
        return (Tokenlist)((Object)this.tokenlist.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SpecialtokensConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Tokenlist
    extends InnerNode {
        private final StringNode name;
        private final InnerNodeVector<Tokens> tokens;

        public Tokenlist(Builder builder) {
            this(builder, true);
        }

        private Tokenlist(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for specialtokens.tokenlist[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.tokens = Tokens.createVector(builder.tokens);
        }

        public String name() {
            return this.name.value();
        }

        public List<Tokens> tokens() {
            return this.tokens;
        }

        public Tokens tokens(int i) {
            return (Tokens)((Object)this.tokens.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Tokenlist newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("tokenlist");
            return changes;
        }

        private static InnerNodeVector<Tokenlist> createVector(List<Builder> builders) {
            ArrayList<Tokenlist> elems = new ArrayList<Tokenlist>();
            for (Builder b : builders) {
                elems.add(new Tokenlist(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Tokens
        extends InnerNode {
            private final StringNode token;
            private final StringNode replace;

            public Tokens(Builder builder) {
                this(builder, true);
            }

            private Tokens(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for specialtokens.tokenlist[].tokens[] must be initialized: " + builder.__uninitialized);
                }
                this.token = builder.token == null ? new StringNode() : new StringNode(builder.token);
                this.replace = builder.replace == null ? new StringNode(SpecialtokensConfig.CONFIG_DEF_VERSION) : new StringNode(builder.replace);
            }

            public String token() {
                return this.token.value();
            }

            public String replace() {
                return this.replace.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Tokens newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("tokens");
                return changes;
            }

            private static InnerNodeVector<Tokens> createVector(List<Builder> builders) {
                ArrayList<Tokens> elems = new ArrayList<Tokens>();
                for (Builder b : builders) {
                    elems.add(new Tokens(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("token"));
                private String token = null;
                private String replace = null;

                public Builder() {
                }

                public Builder(Tokens config) {
                    this.token(config.token());
                    this.replace(config.replace());
                }

                private Builder override(Builder __superior) {
                    if (__superior.token != null) {
                        this.token(__superior.token);
                    }
                    if (__superior.replace != null) {
                        this.replace(__superior.replace);
                    }
                    return this;
                }

                public Builder token(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.token = __value;
                    this.__uninitialized.remove("token");
                    return this;
                }

                public Builder replace(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.replace = __value;
                    return this;
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            public List<Tokens.Builder> tokens = new ArrayList<Tokens.Builder>();

            public Builder() {
            }

            public Builder(Tokenlist config) {
                this.name(config.name());
                for (Tokens t : config.tokens()) {
                    this.tokens(new Tokens.Builder(t));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.tokens.isEmpty()) {
                    this.tokens.addAll(__superior.tokens);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder tokens(Tokens.Builder __builder) {
                this.tokens.add(__builder);
                return this;
            }

            public Builder tokens(List<Tokens.Builder> __builders) {
                this.tokens = __builders;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String makefsaPath = null;
        public List<Tokenlist.Builder> tokenlist = new ArrayList<Tokenlist.Builder>();

        public Builder() {
        }

        public Builder(SpecialtokensConfig config) {
            this.makefsaPath(config.makefsaPath());
            for (Tokenlist t : config.tokenlist()) {
                this.tokenlist(new Tokenlist.Builder(t));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.makefsaPath != null) {
                this.makefsaPath(__superior.makefsaPath);
            }
            if (!__superior.tokenlist.isEmpty()) {
                this.tokenlist.addAll(__superior.tokenlist);
            }
            return this;
        }

        public Builder makefsaPath(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.makefsaPath = __value;
            return this;
        }

        public Builder tokenlist(Tokenlist.Builder __builder) {
            this.tokenlist.add(__builder);
            return this;
        }

        public Builder tokenlist(List<Tokenlist.Builder> __builders) {
            this.tokenlist = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SpecialtokensConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SpecialtokensConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SpecialtokensConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

