/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.hosted.athenz.instanceproviderservice.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class AthenzProviderServiceConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "a6bff9551be4d33bce18d5e5f7628d85";
    public static final String CONFIG_DEF_NAME = "athenz-provider-service";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.hosted.athenz.instanceproviderservice.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.hosted.athenz.instanceproviderservice.config", "zones{}.domain string", "zones{}.serviceName string", "zones{}.secretName string", "zones{}.secretVersion int", "zones{}.certDnsSuffix string", "zones{}.ztsUrl string", "athenzCaTrustStore string", "updatePeriodDays int default=1"};
    private final Map<String, Zones> zones;
    private final StringNode athenzCaTrustStore;
    private final IntegerNode updatePeriodDays;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public AthenzProviderServiceConfig(Builder builder) {
        this(builder, true);
    }

    private AthenzProviderServiceConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for athenz-provider-service must be initialized: " + builder.__uninitialized);
        }
        this.zones = Zones.createMap(builder.zones);
        this.athenzCaTrustStore = builder.athenzCaTrustStore == null ? new StringNode() : new StringNode(builder.athenzCaTrustStore);
        this.updatePeriodDays = builder.updatePeriodDays == null ? new IntegerNode(1) : new IntegerNode(builder.updatePeriodDays.intValue());
    }

    public Map<String, Zones> zones() {
        return Collections.unmodifiableMap(this.zones);
    }

    public Zones zones(String key) {
        return this.zones.get(key);
    }

    public String athenzCaTrustStore() {
        return this.athenzCaTrustStore.value();
    }

    public int updatePeriodDays() {
        return this.updatePeriodDays.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(AthenzProviderServiceConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Zones
    extends InnerNode {
        private final StringNode domain;
        private final StringNode serviceName;
        private final StringNode secretName;
        private final IntegerNode secretVersion;
        private final StringNode certDnsSuffix;
        private final StringNode ztsUrl;

        public Zones(Builder builder) {
            this(builder, true);
        }

        private Zones(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for athenz-provider-service.zones{} must be initialized: " + builder.__uninitialized);
            }
            this.domain = builder.domain == null ? new StringNode() : new StringNode(builder.domain);
            this.serviceName = builder.serviceName == null ? new StringNode() : new StringNode(builder.serviceName);
            this.secretName = builder.secretName == null ? new StringNode() : new StringNode(builder.secretName);
            this.secretVersion = builder.secretVersion == null ? new IntegerNode() : new IntegerNode(builder.secretVersion.intValue());
            this.certDnsSuffix = builder.certDnsSuffix == null ? new StringNode() : new StringNode(builder.certDnsSuffix);
            this.ztsUrl = builder.ztsUrl == null ? new StringNode() : new StringNode(builder.ztsUrl);
        }

        public String domain() {
            return this.domain.value();
        }

        public String serviceName() {
            return this.serviceName.value();
        }

        public String secretName() {
            return this.secretName.value();
        }

        public int secretVersion() {
            return this.secretVersion.value();
        }

        public String certDnsSuffix() {
            return this.certDnsSuffix.value();
        }

        public String ztsUrl() {
            return this.ztsUrl.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Zones newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("zones");
            return changes;
        }

        private static Map<String, Zones> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Zones> ret = new LinkedHashMap<String, Zones>();
            for (String key : builders.keySet()) {
                ret.put(key, new Zones(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("domain", "serviceName", "secretName", "secretVersion", "certDnsSuffix", "ztsUrl"));
            private String domain = null;
            private String serviceName = null;
            private String secretName = null;
            private Integer secretVersion = null;
            private String certDnsSuffix = null;
            private String ztsUrl = null;

            public Builder() {
            }

            public Builder(Zones config) {
                this.domain(config.domain());
                this.serviceName(config.serviceName());
                this.secretName(config.secretName());
                this.secretVersion(config.secretVersion());
                this.certDnsSuffix(config.certDnsSuffix());
                this.ztsUrl(config.ztsUrl());
            }

            private Builder override(Builder __superior) {
                if (__superior.domain != null) {
                    this.domain(__superior.domain);
                }
                if (__superior.serviceName != null) {
                    this.serviceName(__superior.serviceName);
                }
                if (__superior.secretName != null) {
                    this.secretName(__superior.secretName);
                }
                if (__superior.secretVersion != null) {
                    this.secretVersion(__superior.secretVersion);
                }
                if (__superior.certDnsSuffix != null) {
                    this.certDnsSuffix(__superior.certDnsSuffix);
                }
                if (__superior.ztsUrl != null) {
                    this.ztsUrl(__superior.ztsUrl);
                }
                return this;
            }

            public Builder domain(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.domain = __value;
                this.__uninitialized.remove("domain");
                return this;
            }

            public Builder serviceName(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.serviceName = __value;
                this.__uninitialized.remove("serviceName");
                return this;
            }

            public Builder secretName(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.secretName = __value;
                this.__uninitialized.remove("secretName");
                return this;
            }

            public Builder secretVersion(int __value) {
                this.secretVersion = __value;
                this.__uninitialized.remove("secretVersion");
                return this;
            }

            private Builder secretVersion(String __value) {
                return this.secretVersion(Integer.valueOf(__value));
            }

            public Builder certDnsSuffix(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.certDnsSuffix = __value;
                this.__uninitialized.remove("certDnsSuffix");
                return this;
            }

            public Builder ztsUrl(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.ztsUrl = __value;
                this.__uninitialized.remove("ztsUrl");
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("athenzCaTrustStore"));
        public Map<String, Zones.Builder> zones = new LinkedHashMap<String, Zones.Builder>();
        private String athenzCaTrustStore = null;
        private Integer updatePeriodDays = null;

        public Builder() {
        }

        public Builder(AthenzProviderServiceConfig config) {
            for (Map.Entry<String, Zones> __entry : config.zones().entrySet()) {
                this.zones(__entry.getKey(), new Zones.Builder(__entry.getValue()));
            }
            this.athenzCaTrustStore(config.athenzCaTrustStore());
            this.updatePeriodDays(config.updatePeriodDays());
        }

        private Builder override(Builder __superior) {
            this.zones(__superior.zones);
            if (__superior.athenzCaTrustStore != null) {
                this.athenzCaTrustStore(__superior.athenzCaTrustStore);
            }
            if (__superior.updatePeriodDays != null) {
                this.updatePeriodDays(__superior.updatePeriodDays);
            }
            return this;
        }

        public Builder zones(String __key, Zones.Builder __value) {
            this.zones.put(__key, __value);
            return this;
        }

        public Builder zones(Map<String, Zones.Builder> __values) {
            this.zones.putAll(__values);
            return this;
        }

        public Builder athenzCaTrustStore(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.athenzCaTrustStore = __value;
            this.__uninitialized.remove("athenzCaTrustStore");
            return this;
        }

        public Builder updatePeriodDays(int __value) {
            this.updatePeriodDays = __value;
            return this;
        }

        private Builder updatePeriodDays(String __value) {
            return this.updatePeriodDays(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return AthenzProviderServiceConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return AthenzProviderServiceConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return AthenzProviderServiceConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

