/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ImportedFieldsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "d88d591291793d9a535927a94e3cda62";
    public static final String CONFIG_DEF_NAME = "imported-fields";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "attribute[].name string", "attribute[].referencefield string", "attribute[].targetfield string", "attribute[].datatype enum { STRING, UINT1, UINT2, UINT4, INT8, INT16, INT32, INT64, FLOAT, DOUBLE, PREDICATE, TENSOR, REFERENCE, NONE } default=NONE", "attribute[].collectiontype enum { SINGLE, ARRAY, WEIGHTEDSET } default=SINGLE"};
    private final InnerNodeVector<Attribute> attribute;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ImportedFieldsConfig(Builder builder) {
        this(builder, true);
    }

    private ImportedFieldsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for imported-fields must be initialized: " + builder.__uninitialized);
        }
        this.attribute = Attribute.createVector(builder.attribute);
    }

    public List<Attribute> attribute() {
        return this.attribute;
    }

    public Attribute attribute(int i) {
        return (Attribute)((Object)this.attribute.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ImportedFieldsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Attribute
    extends InnerNode {
        private final StringNode name;
        private final StringNode referencefield;
        private final StringNode targetfield;
        private final Datatype datatype;
        private final Collectiontype collectiontype;

        public Attribute(Builder builder) {
            this(builder, true);
        }

        private Attribute(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for imported-fields.attribute[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.referencefield = builder.referencefield == null ? new StringNode() : new StringNode(builder.referencefield);
            this.targetfield = builder.targetfield == null ? new StringNode() : new StringNode(builder.targetfield);
            this.datatype = builder.datatype == null ? new Datatype(Datatype.NONE) : new Datatype(builder.datatype);
            this.collectiontype = builder.collectiontype == null ? new Collectiontype(Collectiontype.SINGLE) : new Collectiontype(builder.collectiontype);
        }

        public String name() {
            return this.name.value();
        }

        public String referencefield() {
            return this.referencefield.value();
        }

        public String targetfield() {
            return this.targetfield.value();
        }

        public Datatype.Enum datatype() {
            return (Datatype.Enum)((Object)this.datatype.value());
        }

        public Collectiontype.Enum collectiontype() {
            return (Collectiontype.Enum)((Object)this.collectiontype.value());
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
            return changes;
        }

        private static InnerNodeVector<Attribute> createVector(List<Builder> builders) {
            ArrayList<Attribute> elems = new ArrayList<Attribute>();
            for (Builder b : builders) {
                elems.add(new Attribute(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Collectiontype
        extends EnumNode<Enum> {
            public static final Enum SINGLE = Enum.SINGLE;
            public static final Enum ARRAY = Enum.ARRAY;
            public static final Enum WEIGHTEDSET = Enum.WEIGHTEDSET;

            public Collectiontype() {
                this.value = null;
            }

            public Collectiontype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                SINGLE,
                ARRAY,
                WEIGHTEDSET;

            }
        }

        public static final class Datatype
        extends EnumNode<Enum> {
            public static final Enum STRING = Enum.STRING;
            public static final Enum UINT1 = Enum.UINT1;
            public static final Enum UINT2 = Enum.UINT2;
            public static final Enum UINT4 = Enum.UINT4;
            public static final Enum INT8 = Enum.INT8;
            public static final Enum INT16 = Enum.INT16;
            public static final Enum INT32 = Enum.INT32;
            public static final Enum INT64 = Enum.INT64;
            public static final Enum FLOAT = Enum.FLOAT;
            public static final Enum DOUBLE = Enum.DOUBLE;
            public static final Enum PREDICATE = Enum.PREDICATE;
            public static final Enum TENSOR = Enum.TENSOR;
            public static final Enum REFERENCE = Enum.REFERENCE;
            public static final Enum NONE = Enum.NONE;

            public Datatype() {
                this.value = null;
            }

            public Datatype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                STRING,
                UINT1,
                UINT2,
                UINT4,
                INT8,
                INT16,
                INT32,
                INT64,
                FLOAT,
                DOUBLE,
                PREDICATE,
                TENSOR,
                REFERENCE,
                NONE;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "referencefield", "targetfield"));
            private String name = null;
            private String referencefield = null;
            private String targetfield = null;
            private Datatype.Enum datatype = null;
            private Collectiontype.Enum collectiontype = null;

            public Builder() {
            }

            public Builder(Attribute config) {
                this.name(config.name());
                this.referencefield(config.referencefield());
                this.targetfield(config.targetfield());
                this.datatype(config.datatype());
                this.collectiontype(config.collectiontype());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.referencefield != null) {
                    this.referencefield(__superior.referencefield);
                }
                if (__superior.targetfield != null) {
                    this.targetfield(__superior.targetfield);
                }
                if (__superior.datatype != null) {
                    this.datatype(__superior.datatype);
                }
                if (__superior.collectiontype != null) {
                    this.collectiontype(__superior.collectiontype);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder referencefield(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.referencefield = __value;
                this.__uninitialized.remove("referencefield");
                return this;
            }

            public Builder targetfield(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.targetfield = __value;
                this.__uninitialized.remove("targetfield");
                return this;
            }

            public Builder datatype(Datatype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.datatype = __value;
                return this;
            }

            private Builder datatype(String __value) {
                return this.datatype(Datatype.Enum.valueOf(__value));
            }

            public Builder collectiontype(Collectiontype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.collectiontype = __value;
                return this;
            }

            private Builder collectiontype(String __value) {
                return this.collectiontype(Collectiontype.Enum.valueOf(__value));
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Attribute.Builder> attribute = new ArrayList<Attribute.Builder>();

        public Builder() {
        }

        public Builder(ImportedFieldsConfig config) {
            for (Attribute a : config.attribute()) {
                this.attribute(new Attribute.Builder(a));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.attribute.isEmpty()) {
                this.attribute.addAll(__superior.attribute);
            }
            return this;
        }

        public Builder attribute(Attribute.Builder __builder) {
            this.attribute.add(__builder);
            return this;
        }

        public Builder attribute(List<Attribute.Builder> __builders) {
            this.attribute = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ImportedFieldsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ImportedFieldsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ImportedFieldsConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

