/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.storage;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class StorDevicesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "96d2fef7bb3f9e0f8942c6b53cadb533";
    public static final String CONFIG_DEF_NAME = "stor-devices";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.storage";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.storage", "root_folder string restart", "disk_path[] string restart", "disk_capacity[] double restart", "device_mapper enum { SIMPLE_MAPPER, REAL_MAPPER } default=REAL_MAPPER restart", "fail_multiple_directories_on_common_events bool default=true restart", "statfs_policy enum { STAT_ALWAYS, STAT_ONCE, STAT_PERIOD, STAT_DYNAMIC } default=STAT_DYNAMIC restart", "statfs_period int default=0 restart"};
    private final StringNode root_folder;
    private final LeafNodeVector<String, StringNode> disk_path;
    private final LeafNodeVector<Double, DoubleNode> disk_capacity;
    private final Device_mapper device_mapper;
    private final BooleanNode fail_multiple_directories_on_common_events;
    private final Statfs_policy statfs_policy;
    private final IntegerNode statfs_period;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorDevicesConfig(Builder builder) {
        this(builder, true);
    }

    private StorDevicesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-devices must be initialized: " + builder.__uninitialized);
        }
        this.root_folder = builder.root_folder == null ? new StringNode() : new StringNode(builder.root_folder);
        this.disk_path = new LeafNodeVector(builder.disk_path, (LeafNode)new StringNode());
        this.disk_capacity = new LeafNodeVector(builder.disk_capacity, (LeafNode)new DoubleNode());
        this.device_mapper = builder.device_mapper == null ? new Device_mapper(Device_mapper.REAL_MAPPER) : new Device_mapper(builder.device_mapper);
        this.fail_multiple_directories_on_common_events = builder.fail_multiple_directories_on_common_events == null ? new BooleanNode(true) : new BooleanNode(builder.fail_multiple_directories_on_common_events.booleanValue());
        this.statfs_policy = builder.statfs_policy == null ? new Statfs_policy(Statfs_policy.STAT_DYNAMIC) : new Statfs_policy(builder.statfs_policy);
        this.statfs_period = builder.statfs_period == null ? new IntegerNode(0) : new IntegerNode(builder.statfs_period.intValue());
    }

    public String root_folder() {
        return this.root_folder.value();
    }

    public List<String> disk_path() {
        return this.disk_path.asList();
    }

    public String disk_path(int i) {
        return ((StringNode)this.disk_path.get(i)).value();
    }

    public List<Double> disk_capacity() {
        return this.disk_capacity.asList();
    }

    public double disk_capacity(int i) {
        return ((DoubleNode)this.disk_capacity.get(i)).value();
    }

    public Device_mapper.Enum device_mapper() {
        return (Device_mapper.Enum)((Object)this.device_mapper.value());
    }

    public boolean fail_multiple_directories_on_common_events() {
        return this.fail_multiple_directories_on_common_events.value();
    }

    public Statfs_policy.Enum statfs_policy() {
        return (Statfs_policy.Enum)((Object)this.statfs_policy.value());
    }

    public int statfs_period() {
        return this.statfs_period.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorDevicesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.root_folder, (Node)newConfig.root_folder, "root_folder", "Root directory for all files related to this storage node.\nWill typically be \"$VESPA_HOME/var/db/vespa/vds/<cluster>/<nodetype>/<index>\"\nWithin this directory the \"disks/d<dirindex>\" directories/symlinks will\ncontain the actual data stored by storage.");
        changes.compareArray(this.disk_path, newConfig.disk_path, "disk_path", "List of disks to store the storage data in. Make an empty directory for\neach disk_path[index] if it does not exist yet, and make a symlink from each\n\"<root_folder>/disks/d<index>\" to disk_path[index] if it doesn't exist yet.", (a, b) -> new ChangesRequiringRestart("disk_path").compare(a, b, CONFIG_DEF_VERSION, "List of disks to store the storage data in. Make an empty directory for\neach disk_path[index] if it does not exist yet, and make a symlink from each\n\"<root_folder>/disks/d<index>\" to disk_path[index] if it doesn't exist yet."));
        changes.compareArray(this.disk_capacity, newConfig.disk_capacity, "disk_capacity", "Capacity of the disks on this node. How much data and load will each disk\nget relative to the other disks on this node. The default disk capacity is\n1.0. If disk capacity array size does not match disk counts, it will use the\nvalues that exist, and use 1.0 for the rest.", (a, b) -> new ChangesRequiringRestart("disk_capacity").compare(a, b, CONFIG_DEF_VERSION, "Capacity of the disks on this node. How much data and load will each disk\nget relative to the other disks on this node. The default disk capacity is\n1.0. If disk capacity array size does not match disk counts, it will use the\nvalues that exist, and use 1.0 for the rest."));
        changes.compare((Node)this.device_mapper, (Node)newConfig.device_mapper, "device_mapper", "The device mapper is used to detect what storage directories map to what\npartitions and disks, such that then a disk event arise, it arise for all\ndirectories using that disk. Storage has two different device mappers. One\nthat fakes the devices, assuming all VDS directories use unique partitions\nand disks, and a real one trying to detect what is actually being used.\n \nAdvantage of simple one is that one can fake multiple disks, which may be\nuseful in testing. Problem being that then storage gives clues that it has\nadded X bytes to a partition, other directories on the same partition will\nnot be adjusted. Thus, one might want to cache stat results less due to\nnumbers being incorrect.\n \nIf using a real mapper, disk events such as IO failures will mark all\ndirectories using partitions on that disk bad, rather than just the directory\ncontaining the file which we had trouble using. We dont detect real physical\ndisks. Currently we detect whether they use the same *nix device or not.");
        changes.compare((Node)this.fail_multiple_directories_on_common_events, (Node)newConfig.fail_multiple_directories_on_common_events, "fail_multiple_directories_on_common_events", "Whether or not to fail directories on same partition and/or disk as another\ndirectory on failures. Our goal is to return directory errors on failures\nonly affecting one directory, partition failures for errors only affecting a\nsingle partition and so on. In reality, however, it is very hard to know if\nthe problem is partition or disk related for instance. Both a corrupt\nfilesystem and a bad disk may show the same IO error to storage. We\nrecommend having this enabled, so we can attempt to do logic, but it is\npossible to turn it of, in case you see the logic doesnt work for you (and\nthat you get more directories than needed marked down and that troubles\nyour system)");
        changes.compare((Node)this.statfs_policy, (Node)newConfig.statfs_policy, "statfs_policy", "Storage stats file systems regularily to check how full they are. To avoid\nconstantly calling this system call storage may cache the result and validate\nchanges once in a while. The always policy always calls the real statfs\nfunction when asked for disk fullness. This may be useful in system testing\nwhere you want to test disk full situations (but not this policy). The stat\nonce policy does a single stat upon start, and depends on storage to give\nclues about changes in disk usage to report correct results (currently not\nrecommended since we dont guarantuee the clues are 100% correct). The period\npolicy asks for each Nth request, and so does the dynamic policy, but the\nlatter one has a dynamic period, being large when disk has low fill rate, but\nsmall with high fillrate. The dynamic policy is recommended as it doesnt\nrequire exact change clues requires few stat calls as long as the disks\narent close to full.");
        changes.compare((Node)this.statfs_period, (Node)newConfig.statfs_period, "statfs_period", "If set to non-null, overrides the code default period for stat period and\ndynamic policies. See PartitionMonitor class for details.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Statfs_policy
    extends EnumNode<Enum> {
        public static final Enum STAT_ALWAYS = Enum.STAT_ALWAYS;
        public static final Enum STAT_ONCE = Enum.STAT_ONCE;
        public static final Enum STAT_PERIOD = Enum.STAT_PERIOD;
        public static final Enum STAT_DYNAMIC = Enum.STAT_DYNAMIC;

        public Statfs_policy() {
            this.value = null;
        }

        public Statfs_policy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(@NonNull String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            STAT_ALWAYS,
            STAT_ONCE,
            STAT_PERIOD,
            STAT_DYNAMIC;

        }
    }

    public static final class Device_mapper
    extends EnumNode<Enum> {
        public static final Enum SIMPLE_MAPPER = Enum.SIMPLE_MAPPER;
        public static final Enum REAL_MAPPER = Enum.REAL_MAPPER;

        public Device_mapper() {
            this.value = null;
        }

        public Device_mapper(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(@NonNull String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            SIMPLE_MAPPER,
            REAL_MAPPER;

        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("root_folder"));
        private String root_folder = null;
        public List<String> disk_path = new ArrayList<String>();
        public List<Double> disk_capacity = new ArrayList<Double>();
        private Device_mapper.Enum device_mapper = null;
        private Boolean fail_multiple_directories_on_common_events = null;
        private Statfs_policy.Enum statfs_policy = null;
        private Integer statfs_period = null;

        public Builder() {
        }

        public Builder(StorDevicesConfig config) {
            this.root_folder(config.root_folder());
            this.disk_path(config.disk_path());
            this.disk_capacity(config.disk_capacity());
            this.device_mapper(config.device_mapper());
            this.fail_multiple_directories_on_common_events(config.fail_multiple_directories_on_common_events());
            this.statfs_policy(config.statfs_policy());
            this.statfs_period(config.statfs_period());
        }

        private Builder override(Builder __superior) {
            if (__superior.root_folder != null) {
                this.root_folder(__superior.root_folder);
            }
            if (!__superior.disk_path.isEmpty()) {
                this.disk_path.addAll(__superior.disk_path);
            }
            if (!__superior.disk_capacity.isEmpty()) {
                this.disk_capacity.addAll(__superior.disk_capacity);
            }
            if (__superior.device_mapper != null) {
                this.device_mapper(__superior.device_mapper);
            }
            if (__superior.fail_multiple_directories_on_common_events != null) {
                this.fail_multiple_directories_on_common_events(__superior.fail_multiple_directories_on_common_events);
            }
            if (__superior.statfs_policy != null) {
                this.statfs_policy(__superior.statfs_policy);
            }
            if (__superior.statfs_period != null) {
                this.statfs_period(__superior.statfs_period);
            }
            return this;
        }

        public Builder root_folder(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.root_folder = __value;
            this.__uninitialized.remove("root_folder");
            return this;
        }

        public Builder disk_path(String __value) {
            this.disk_path.add(__value);
            return this;
        }

        public Builder disk_path(Collection<String> __values) {
            this.disk_path.addAll(__values);
            return this;
        }

        public Builder disk_capacity(Double __value) {
            this.disk_capacity.add(__value);
            return this;
        }

        public Builder disk_capacity(Collection<Double> __values) {
            this.disk_capacity.addAll(__values);
            return this;
        }

        private Builder disk_capacity(String __value) {
            return this.disk_capacity(Double.valueOf(__value));
        }

        public Builder device_mapper(Device_mapper.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.device_mapper = __value;
            return this;
        }

        private Builder device_mapper(String __value) {
            return this.device_mapper(Device_mapper.Enum.valueOf(__value));
        }

        public Builder fail_multiple_directories_on_common_events(boolean __value) {
            this.fail_multiple_directories_on_common_events = __value;
            return this;
        }

        private Builder fail_multiple_directories_on_common_events(String __value) {
            return this.fail_multiple_directories_on_common_events(Boolean.valueOf(__value));
        }

        public Builder statfs_policy(Statfs_policy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.statfs_policy = __value;
            return this;
        }

        private Builder statfs_policy(String __value) {
            return this.statfs_policy(Statfs_policy.Enum.valueOf(__value));
        }

        public Builder statfs_period(int __value) {
            this.statfs_period = __value;
            return this;
        }

        private Builder statfs_period(String __value) {
            return this.statfs_period(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorDevicesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorDevicesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorDevicesConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

