/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileReference;
import com.yahoo.config.ModelReference;
import com.yahoo.config.UrlReference;
import com.yahoo.slime.Inspector;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigTransformer;
import com.yahoo.vespa.config.UrlDownloader;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigPayloadApplier<T extends ConfigInstance.Builder> {
    private static final Logger log = Logger.getLogger(ConfigPayloadApplier.class.getPackage().getName());
    private final ConfigInstance.Builder rootBuilder;
    private final ConfigTransformer.PathAcquirer pathAcquirer;
    private final UrlDownloader urlDownloader;
    private final Deque<NamedBuilder> stack = new ArrayDeque<NamedBuilder>();
    private final Map<String, Method> methodCache = new HashMap<String, Method>();
    private final Set<String> pathFieldSet = new HashSet<String>();
    private final Set<String> optionalPathFieldSet = new HashSet<String>();
    private final Set<String> urlFieldSet = new HashSet<String>();
    private final Set<String> modelFieldSet = new HashSet<String>();
    private final Map<String, Constructor<?>> constructorCache = new HashMap();

    public ConfigPayloadApplier(T builder) {
        this(builder, new IdentityPathAcquirer(), null);
    }

    public ConfigPayloadApplier(T builder, ConfigTransformer.PathAcquirer pathAcquirer, UrlDownloader urlDownloader) {
        this.rootBuilder = builder;
        this.pathAcquirer = pathAcquirer;
        this.urlDownloader = urlDownloader;
    }

    public void applyPayload(ConfigPayload payload) {
        this.stack.push(new NamedBuilder((ConfigBuilder)this.rootBuilder));
        try {
            this.handleValue((Inspector)payload.getSlime().get());
        }
        catch (Exception e) {
            throw new RuntimeException("Not able to create config builder for payload '" + payload.toString() + "'", e);
        }
    }

    private void handleValue(Inspector inspector) {
        switch (inspector.type()) {
            case NIX: 
            case BOOL: 
            case LONG: 
            case DOUBLE: 
            case STRING: 
            case DATA: {
                this.handleLeafValue(inspector);
                break;
            }
            case ARRAY: {
                this.handleARRAY(inspector);
                break;
            }
            case OBJECT: {
                this.handleOBJECT(inspector);
                break;
            }
            default: {
                assert (false) : "Should not be reached";
                break;
            }
        }
    }

    private void handleARRAY(Inspector inspector) {
        inspector.traverse(this::handleArrayEntry);
    }

    private void handleArrayEntry(int idx, Inspector inspector) {
        try {
            String name = this.stack.peek().nameStack().peek();
            if (inspector.type() == com.yahoo.slime.Type.OBJECT) {
                NamedBuilder builder = this.createBuilder(this.stack.peek(), name);
                if (builder == null) {
                    return;
                }
                this.stack.push(builder);
            }
            this.handleValue(inspector);
            if (inspector.type() == com.yahoo.slime.Type.OBJECT) {
                this.stack.peek().nameStack().pop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleOBJECT(Inspector inspector) {
        inspector.traverse(this::handleObjectEntry);
        NamedBuilder builder = this.stack.pop();
        if (!this.stack.isEmpty()) {
            try {
                this.invokeSetter(this.stack.peek().builder, builder.peekName(), builder.builder);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set '" + builder.peekName() + "' for value '" + String.valueOf(builder.builder()) + "'", e);
            }
        }
    }

    private void handleObjectEntry(String name, Inspector inspector) {
        try {
            NamedBuilder parentBuilder = this.stack.peek();
            if (inspector.type() == com.yahoo.slime.Type.OBJECT) {
                if (this.isMapField(parentBuilder, name)) {
                    parentBuilder.nameStack().push(name);
                    this.handleMap(inspector);
                    parentBuilder.nameStack().pop();
                    return;
                }
                NamedBuilder builder = this.createBuilder(parentBuilder, name);
                if (builder == null) {
                    return;
                }
                this.stack.push(builder);
            } else if (inspector.type() == com.yahoo.slime.Type.ARRAY) {
                for (int i = 0; i < inspector.children(); ++i) {
                    parentBuilder.nameStack().push(name);
                }
            } else {
                parentBuilder.nameStack().push(name);
            }
            this.handleValue(inspector);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMap(Inspector inspector) {
        inspector.traverse((name, value) -> {
            switch (value.type()) {
                case OBJECT: {
                    this.handleInnerMap(name, value);
                    break;
                }
                case ARRAY: {
                    throw new IllegalArgumentException("Never heard of array inside maps before");
                }
                default: {
                    this.setMapLeafValue(name, value);
                }
            }
        });
    }

    private void handleInnerMap(String name, Inspector inspector) {
        NamedBuilder builder = this.createBuilder(this.stack.peek(), this.stack.peek().peekName());
        if (builder == null) {
            throw new RuntimeException("Missing map builder (this should never happen): " + String.valueOf(this.stack.peek()));
        }
        this.setMapLeafValue(name, builder.builder());
        this.stack.push(builder);
        inspector.traverse(this::handleObjectEntry);
        this.stack.pop();
    }

    private void setMapLeafValue(String key, Object value) {
        NamedBuilder parent = this.stack.peek();
        ConfigBuilder builder = parent.builder();
        String methodName = parent.peekName();
        try {
            this.invokeSetter(builder, methodName, key, this.resolveValue(builder, methodName, value));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Name: " + methodName + ", value '" + String.valueOf(value) + "'", e);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.INFO, "Skipping unknown field " + methodName + " in " + String.valueOf(this.rootBuilder));
        }
    }

    private boolean isMapField(NamedBuilder parentBuilder, String name) {
        ConfigBuilder builder = parentBuilder.builder();
        try {
            Field f = builder.getClass().getField(name);
            return f.getType().getName().equals("java.util.Map");
        }
        catch (Exception e) {
            return false;
        }
    }

    NamedBuilder createBuilder(NamedBuilder parentBuilder, String name) {
        ConfigBuilder builder = parentBuilder.builder();
        Object newBuilder = this.getBuilderForStruct(name, builder.getClass().getDeclaringClass());
        if (newBuilder == null) {
            return null;
        }
        return new NamedBuilder((ConfigBuilder)newBuilder, name);
    }

    private void handleLeafValue(Inspector value) {
        NamedBuilder peek = this.stack.peek();
        String name = peek.nameStack().pop();
        ConfigBuilder builder = peek.builder();
        this.setValueForLeafNode(builder, name, value);
    }

    private void setValueForLeafNode(Object builder, String methodName, Inspector value) {
        try {
            this.invokeSetter(builder, methodName, this.resolveValue(builder, methodName, value));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Name: " + methodName + ", value '" + String.valueOf(value) + "'", e);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.INFO, "Skipping unknown field " + methodName + " in " + String.valueOf(builder.getClass()));
        }
    }

    private Object resolveValue(Object builder, String methodName, Object rawValue) {
        if (rawValue instanceof ConfigBuilder) {
            return rawValue;
        }
        Inspector value = (Inspector)rawValue;
        if (this.isPathField(builder, methodName)) {
            return this.resolvePath(value.asString());
        }
        if (this.isOptionalPathField(builder, methodName)) {
            String v = value.asString();
            return this.resolvePath(v.isEmpty() ? Optional.empty() : Optional.of(v));
        }
        if (this.isUrlField(builder, methodName)) {
            return value.asString().isEmpty() ? "" : this.resolveUrl(value.asString());
        }
        if (this.isModelField(builder, methodName)) {
            return value.asString().isEmpty() ? "" : this.resolveModel(value.asString());
        }
        return this.getValueFromInspector(value);
    }

    private boolean isClientside() {
        return this.urlDownloader != null;
    }

    private FileReference resolvePath(String value) {
        Path path = this.pathAcquirer.getPath(new FileReference(value));
        return new FileReference(path.toString());
    }

    private Optional<FileReference> resolvePath(Optional<String> value) {
        return value.isEmpty() ? Optional.empty() : Optional.of(this.resolvePath(value.get()));
    }

    private UrlReference resolveUrl(String url) {
        if (!this.isClientside()) {
            return new UrlReference(url);
        }
        File file = this.urlDownloader.waitFor(new UrlReference(url), Duration.ofMinutes(60L));
        return new UrlReference(file.getAbsolutePath());
    }

    private ModelReference resolveModel(String modelStringValue) {
        ModelReference model = ModelReference.valueOf((String)modelStringValue);
        if (model.isResolved()) {
            return model;
        }
        if (this.isClientside() && model.url().isPresent()) {
            return ModelReference.resolved((Path)Path.of(this.resolveUrl(((UrlReference)model.url().get()).value()).value(), new String[0]));
        }
        if (this.isClientside() && model.path().isPresent()) {
            return ModelReference.resolved((Path)Path.of(this.resolvePath(((FileReference)model.path().get()).value()).value(), new String[0]));
        }
        return model;
    }

    private static String methodCacheKey(Object builder, String methodName, Object[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append(builder.getClass().getName()).append(".").append(methodName);
        for (Object param : params) {
            sb.append(".").append(param.getClass().getName());
        }
        return sb.toString();
    }

    private Method lookupSetter(Object builder, String methodName, Object ... params) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            parameterTypes[i] = params[i].getClass();
        }
        Method method = builder.getClass().getDeclaredMethod(methodName, parameterTypes);
        method.setAccessible(true);
        return method;
    }

    private void invokeSetter(Object builder, String methodName, Object ... params) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String key = ConfigPayloadApplier.methodCacheKey(builder, methodName, params);
        Method method = this.methodCache.get(key);
        if (method == null) {
            method = this.lookupSetter(builder, methodName, params);
            this.methodCache.put(key, method);
        }
        method.invoke(builder, params);
    }

    private Object getValueFromInspector(Inspector inspector) {
        switch (inspector.type()) {
            case STRING: {
                return inspector.asString();
            }
            case LONG: {
                return String.valueOf(inspector.asLong());
            }
            case DOUBLE: {
                return String.valueOf(inspector.asDouble());
            }
            case NIX: {
                return null;
            }
            case BOOL: {
                return String.valueOf(inspector.asBool());
            }
            case DATA: {
                return String.valueOf(inspector.asData());
            }
        }
        throw new IllegalArgumentException("Unhandled type " + String.valueOf(inspector.type()));
    }

    private boolean isPathField(Object builder, String methodName) {
        return this.isFieldType(this.pathFieldSet, builder, methodName, (Type)((Object)FileReference.class));
    }

    private boolean isOptionalPathField(Object builder, String methodName) {
        return this.isFieldType(this.optionalPathFieldSet, builder, methodName, (Type)((Object)Optional.class));
    }

    private boolean isUrlField(Object builder, String methodName) {
        return this.isFieldType(this.urlFieldSet, builder, methodName, (Type)((Object)UrlReference.class));
    }

    private boolean isModelField(Object builder, String methodName) {
        return this.isFieldType(this.modelFieldSet, builder, methodName, (Type)((Object)ModelReference.class));
    }

    private boolean isFieldType(Set<String> fieldSet, Object builder, String methodName, Type type) {
        String key = ConfigPayloadApplier.fieldKey(builder, methodName);
        if (fieldSet.contains(key)) {
            return true;
        }
        boolean isType = false;
        try {
            Field field = builder.getClass().getDeclaredField(methodName);
            Type fieldType = field.getGenericType();
            if (fieldType instanceof Class && fieldType == type) {
                isType = true;
            } else if (fieldType instanceof ParameterizedType) {
                isType = this.isParameterizedWith((ParameterizedType)fieldType, type);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (isType) {
            fieldSet.add(key);
        }
        return isType;
    }

    private static String fieldKey(Object builder, String methodName) {
        return builder.getClass().getName() + "." + methodName;
    }

    private boolean isParameterizedWith(ParameterizedType fieldType, Type type) {
        int numTypeArgs = fieldType.getActualTypeArguments().length;
        if (numTypeArgs > 0) {
            return fieldType.getActualTypeArguments()[numTypeArgs - 1] == type;
        }
        return false;
    }

    private String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private Constructor<?> lookupBuilderForStruct(String structName, Class<?> currentClass) {
        String currentClassName = currentClass.getName();
        Class<?> structClass = this.getInnerClass(currentClass, currentClassName + "$" + structName);
        if (structClass == null) {
            log.info("Could not find nested class '" + currentClassName + "$" + structName + "'. Ignoring it, assuming it's been added to a newer version of the config.");
            return null;
        }
        return this.getStructBuilderConstructor(structClass, currentClassName, structName);
    }

    private Constructor<?> getStructBuilderConstructor(Class<?> structClass, String currentClassName, String builderName) {
        String structBuilderName = currentClassName + "$" + builderName + "$Builder";
        Class<?> structBuilderClass = this.getInnerClass(structClass, structBuilderName);
        if (structBuilderClass == null) {
            throw new RuntimeException("Could not find builder class " + structBuilderName);
        }
        try {
            return structBuilderClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not create class ''" + structBuilderClass.getName() + "'");
        }
    }

    private Class<?> getInnerClass(Class<?> clazz, String name) {
        for (Class<?> cls : clazz.getDeclaredClasses()) {
            if (!cls.getName().equals(name)) continue;
            return cls;
        }
        return null;
    }

    private static String constructorCacheKey(String builderName, String name, Class<?> currentClass) {
        return builderName + "." + name + "." + currentClass.getName();
    }

    private Object getBuilderForStruct(String name, Class<?> currentClass) {
        String structName = this.capitalize(name);
        String key = ConfigPayloadApplier.constructorCacheKey(structName, name, currentClass);
        Constructor<?> constructor = this.constructorCache.get(key);
        if (constructor == null) {
            constructor = this.lookupBuilderForStruct(structName, currentClass);
            if (constructor == null) {
                return null;
            }
            this.constructorCache.put(key, constructor);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create class ''" + constructor.getDeclaringClass().getName() + "'");
        }
    }

    static class IdentityPathAcquirer
    implements ConfigTransformer.PathAcquirer {
        IdentityPathAcquirer() {
        }

        @Override
        public Path getPath(FileReference fileReference) {
            return new File(fileReference.value()).toPath();
        }
    }

    private static class NamedBuilder {
        private final ConfigBuilder builder;
        private final Deque<String> names = new ArrayDeque<String>();

        NamedBuilder(ConfigBuilder builder) {
            this.builder = builder;
        }

        NamedBuilder(ConfigBuilder builder, String name) {
            this(builder);
            this.names.push(name);
        }

        ConfigBuilder builder() {
            return this.builder;
        }

        String peekName() {
            return this.names.peek();
        }

        Deque<String> nameStack() {
            return this.names;
        }

        public String toString() {
            return this.builder() == null ? "null" : this.builder.toString() + " names=" + String.valueOf(this.names);
        }
    }
}

