/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.text.StringUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class DefContent {
    private final List<String> data;

    private DefContent(List<String> data) {
        this.data = data;
    }

    public String[] asStringArray() {
        return this.data.toArray(new String[this.data.size()]);
    }

    public List<String> asList() {
        return this.data;
    }

    public String asString() {
        return StringUtilities.implode((String[])this.asStringArray(), (String)"\n");
    }

    static DefContent fromSlime(Inspector data) {
        ArrayList<String> lst = new ArrayList<String>();
        data.traverse((idx, inspector) -> lst.add(inspector.asString()));
        return new DefContent(lst);
    }

    public static DefContent fromClass(Class<? extends ConfigInstance> clazz) {
        return DefContent.fromArray(DefContent.defSchema(clazz));
    }

    public static DefContent fromList(List<String> def) {
        return new DefContent(def);
    }

    public static DefContent fromArray(String[] schema) {
        return DefContent.fromList(List.of(schema));
    }

    private static String[] defSchema(Class<? extends ConfigInstance> configClass) {
        if (configClass == null) {
            return new String[0];
        }
        try {
            Field f = configClass.getField("CONFIG_DEF_SCHEMA");
            return (String[])f.get(configClass);
        }
        catch (NoSuchFieldException e) {
            return new String[0];
        }
        catch (Exception e) {
            throw new ConfigurationRuntimeException((Throwable)e);
        }
    }

    public void serialize(Cursor cursor) {
        for (String line : this.data) {
            cursor.addString(line);
        }
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }
}

