/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;

public class ConfigKey<CONFIGCLASS extends ConfigInstance>
implements Comparable<ConfigKey<?>> {
    private final String name;
    private final String configId;
    private final String namespace;
    private final Class<CONFIGCLASS> configClass;

    public ConfigKey(String name, String configIdString, String namespace) {
        this(name, configIdString, namespace, null);
    }

    public ConfigKey(Class<CONFIGCLASS> clazz, String configIdString) {
        this(ConfigKey.getFieldFromClass(clazz, "CONFIG_DEF_NAME"), configIdString, ConfigKey.getFieldFromClass(clazz, "CONFIG_DEF_NAMESPACE"), clazz);
    }

    public ConfigKey(String name, String configIdString, String namespace, Class<CONFIGCLASS> clazz) {
        if (name == null || name.isEmpty()) {
            throw new ConfigurationRuntimeException("Config name cannot be null or empty!");
        }
        if (namespace == null || namespace.isEmpty()) {
            throw new ConfigurationRuntimeException("Config namespace cannot be null or empty!");
        }
        this.name = name;
        this.configId = configIdString == null ? "" : configIdString;
        this.namespace = namespace;
        this.configClass = clazz;
    }

    @Override
    public int compareTo(ConfigKey<?> o) {
        if (!o.getNamespace().equals(this.getNamespace())) {
            return this.getNamespace().compareTo(o.getNamespace());
        }
        if (!o.getName().equals(this.getName())) {
            return this.getName().compareTo(o.getName());
        }
        return this.getConfigId().compareTo(o.getConfigId());
    }

    private static String getFieldFromClass(Class<?> clazz, String fieldName) {
        try {
            return (String)clazz.getField(fieldName).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ConfigurationRuntimeException("No such field '" + fieldName + "' in class " + clazz + ", or could not access field.", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigKey)) {
            return false;
        }
        ConfigKey key = (ConfigKey)o;
        return this.name.equals(key.name) && this.configId.equals(key.configId) && this.namespace.equals(key.namespace);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.name.hashCode();
        hash = 37 * hash + this.configId.hashCode();
        hash = 37 * hash + this.namespace.hashCode();
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Class<CONFIGCLASS> getConfigClass() {
        return this.configClass;
    }

    public String toString() {
        return "name=" + this.namespace + "." + this.name + ",configId=" + this.configId;
    }

    public static ConfigKey<?> createFull(String name, String configId, String namespace) {
        return new ConfigKey(name, configId, namespace, null);
    }
}

