/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.jrt.Request;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.Slime;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.Trace;

class SlimeResponseData {
    static final String RESPONSE_VERSION = "version";
    static final String RESPONSE_DEF_NAME = "defName";
    static final String RESPONSE_DEF_NAMESPACE = "defNamespace";
    static final String RESPONSE_DEF_MD5 = "defMD5";
    static final String RESPONSE_CONFIGID = "configId";
    static final String RESPONSE_CLIENT_HOSTNAME = "clientHostname";
    static final String RESPONSE_TRACE = "trace";
    static final String RESPONSE_CONFIG_MD5 = "configMD5";
    static final String RESPONSE_CONFIG_GENERATION = "generation";
    static final String RESPONSE_INTERNAL_REDEPLOY = "internalRedeploy";
    static final String RESPONSE_COMPRESSION_INFO = "compressionInfo";
    private final Request request;
    private Slime data = null;

    SlimeResponseData(Request request) {
        this.request = request;
    }

    private Slime getData() {
        if (this.request.returnValues().size() > 0) {
            if (this.data == null) {
                this.data = new JsonDecoder().decode(new Slime(), Utf8.toBytes((String)this.request.returnValues().get(0).asString()));
            }
            return this.data;
        }
        return new Slime();
    }

    Inspector getResponseField(String responseTrace) {
        return this.getData().get().field(responseTrace);
    }

    long getResponseConfigGeneration() {
        Inspector inspector = this.getResponseField(RESPONSE_CONFIG_GENERATION);
        return inspector.valid() ? inspector.asLong() : -1L;
    }

    Trace getResponseTrace() {
        Inspector trace = this.getResponseField(RESPONSE_TRACE);
        return trace.valid() ? Trace.fromSlime(trace) : Trace.createDummy();
    }

    String getResponseConfigMd5() {
        Inspector inspector = this.getResponseField(RESPONSE_CONFIG_MD5);
        return inspector.valid() ? inspector.asString() : "";
    }

    CompressionInfo getCompressionInfo() {
        return CompressionInfo.fromSlime(this.getResponseField(RESPONSE_COMPRESSION_INFO));
    }

    boolean getResponseInternalRedeployment() {
        Inspector inspector = this.getResponseField(RESPONSE_INTERNAL_REDEPLOY);
        return inspector.valid() ? inspector.asBool() : false;
    }
}

