/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.LZ4PayloadCompressor;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import java.util.Objects;

public class Payload {
    private final Utf8Array data;
    private final CompressionInfo compressionInfo;
    private static final LZ4PayloadCompressor compressor = new LZ4PayloadCompressor();

    private Payload(ConfigPayload payload) {
        this.data = payload.toUtf8Array(true);
        this.compressionInfo = CompressionInfo.create(CompressionType.UNCOMPRESSED, this.data.getByteLength());
    }

    private Payload(Utf8Array payload, CompressionInfo compressionInfo) {
        Objects.requireNonNull(payload, "Payload");
        Objects.requireNonNull(compressionInfo, "CompressionInfo");
        this.data = payload;
        this.compressionInfo = compressionInfo;
    }

    public static Payload from(ConfigPayload payload) {
        return new Payload(payload);
    }

    public static Payload from(String payload) {
        return new Payload((Utf8Array)new Utf8String(payload), CompressionInfo.uncompressed());
    }

    public static Payload from(String payload, CompressionInfo compressionInfo) {
        return new Payload((Utf8Array)new Utf8String(payload), compressionInfo);
    }

    public static Payload from(Utf8Array payload) {
        return new Payload(payload, CompressionInfo.uncompressed());
    }

    public static Payload from(Utf8Array payload, CompressionInfo compressionInfo) {
        return new Payload(payload, compressionInfo);
    }

    public Utf8Array getData() {
        return this.data;
    }

    public Payload withCompression(CompressionType requestedCompression) {
        CompressionType responseCompression = this.compressionInfo.getCompressionType();
        if (requestedCompression == CompressionType.UNCOMPRESSED && responseCompression == CompressionType.LZ4) {
            byte[] buffer = new byte[this.compressionInfo.getUncompressedSize()];
            compressor.decompress(this.data.getBytes(), buffer);
            Utf8Array data = new Utf8Array(buffer);
            CompressionInfo info = CompressionInfo.create(CompressionType.UNCOMPRESSED, this.compressionInfo.getUncompressedSize());
            return Payload.from(data, info);
        }
        if (requestedCompression == CompressionType.LZ4 && responseCompression == CompressionType.UNCOMPRESSED) {
            Utf8Array data = new Utf8Array(compressor.compress(this.data.getBytes()));
            CompressionInfo info = CompressionInfo.create(CompressionType.LZ4, this.data.getByteLength());
            return Payload.from(data, info);
        }
        return Payload.from(this.data, this.compressionInfo);
    }

    public CompressionInfo getCompressionInfo() {
        return this.compressionInfo;
    }

    public String toString() {
        if (this.compressionInfo.getCompressionType() == CompressionType.UNCOMPRESSED) {
            return this.data.toString();
        }
        return this.withCompression(CompressionType.UNCOMPRESSED).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payload other = (Payload)o;
        return this.compressionInfo.equals(other.compressionInfo) && this.data.equals((Object)other.data);
    }

    public int hashCode() {
        return this.data.hashCode() + 31 * this.compressionInfo.hashCode();
    }
}

