/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.buildergen;

import com.yahoo.config.ConfigInstance;
import com.yahoo.vespa.config.buildergen.CompilationTask;
import com.yahoo.vespa.config.buildergen.CompiledBuilder;
import com.yahoo.vespa.config.buildergen.ConfigCompiler;
import com.yahoo.vespa.config.buildergen.ConfigDefinitionClass;
import com.yahoo.vespa.config.buildergen.StringSourceObject;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class LazyConfigCompiler
implements ConfigCompiler {
    private final File outputDirectory;
    private final ClassLoader classLoader;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public LazyConfigCompiler(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        try {
            this.classLoader = new URLClassLoader(new URL[]{outputDirectory.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to create class loader for directory '" + outputDirectory.getAbsolutePath() + "'", e);
        }
    }

    @Override
    public CompiledBuilder compile(ConfigDefinitionClass defClass) {
        List<StringSourceObject> compilationUnits = Arrays.asList(new StringSourceObject(defClass.getName(), defClass.getDefinition()));
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, Locale.ENGLISH, null);
        List<String> options = Arrays.asList("-d", this.outputDirectory.getAbsolutePath());
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
        return new LazyCompiledBuilder(this.classLoader, defClass.getName(), new CompilationTask(task, diagnostics));
    }

    private static class LazyCompiledBuilder
    implements CompiledBuilder {
        private final ClassLoader classLoader;
        private final String classUrl;
        private final CompilationTask compilationTask;

        private LazyCompiledBuilder(ClassLoader classLoader, String classUrl, CompilationTask compilationTask) {
            this.classLoader = classLoader;
            this.classUrl = classUrl;
            this.compilationTask = compilationTask;
        }

        @Override
        public <BUILDER extends ConfigInstance.Builder> BUILDER newInstance() {
            this.compileBuilder();
            String builderClassUrl = this.classUrl + "$Builder";
            return this.loadBuilder(builderClassUrl);
        }

        private void compileBuilder() {
            try {
                this.compilationTask.call();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error compiling '" + this.classUrl + "'", e);
            }
        }

        private <BUILDER extends ConfigInstance.Builder> BUILDER loadBuilder(String builderClassUrl) {
            try {
                Class<?> clazz = this.classLoader.loadClass(builderClassUrl);
                return (BUILDER)((ConfigInstance.Builder)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Error creating new instance of '" + builderClassUrl + "'", e);
            }
        }
    }
}

