/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import java.util.Random;

public class TimingValues {
    public static final long defaultNextConfigTimeout = 1000L;
    private long successTimeout = 600000L;
    private long errorTimeout = 20000L;
    private long initialTimeout = 15000L;
    private long subscribeTimeout = 55000L;
    private long configuredErrorTimeout = -1L;
    private long nextConfigTimeout = 1000L;
    private long fixedDelay = 5000L;
    private long unconfiguredDelay = 1000L;
    private long configuredErrorDelay = 15000L;
    private int maxDelayMultiplier = 10;
    private final Random rand;

    public TimingValues() {
        this.rand = new Random(System.currentTimeMillis());
    }

    public TimingValues(long successTimeout, long errorTimeout, long initialTimeout, long subscribeTimeout, long unconfiguredDelay, long configuredErrorDelay, long fixedDelay, int maxDelayMultiplier) {
        this.successTimeout = successTimeout;
        this.errorTimeout = errorTimeout;
        this.initialTimeout = initialTimeout;
        this.subscribeTimeout = subscribeTimeout;
        this.unconfiguredDelay = unconfiguredDelay;
        this.configuredErrorDelay = configuredErrorDelay;
        this.fixedDelay = fixedDelay;
        this.maxDelayMultiplier = maxDelayMultiplier;
        this.rand = new Random(System.currentTimeMillis());
    }

    private TimingValues(long successTimeout, long errorTimeout, long initialTimeout, long subscribeTimeout, long unconfiguredDelay, long configuredErrorDelay, long fixedDelay, int maxDelayMultiplier, Random rand) {
        this.successTimeout = successTimeout;
        this.errorTimeout = errorTimeout;
        this.initialTimeout = initialTimeout;
        this.subscribeTimeout = subscribeTimeout;
        this.unconfiguredDelay = unconfiguredDelay;
        this.configuredErrorDelay = configuredErrorDelay;
        this.fixedDelay = fixedDelay;
        this.maxDelayMultiplier = maxDelayMultiplier;
        this.rand = rand;
    }

    public TimingValues(TimingValues tv) {
        this(tv.successTimeout, tv.errorTimeout, tv.initialTimeout, tv.subscribeTimeout, tv.unconfiguredDelay, tv.configuredErrorDelay, tv.fixedDelay, tv.maxDelayMultiplier, tv.getRandom());
    }

    public TimingValues(TimingValues tv, Random random) {
        this(tv.successTimeout, tv.errorTimeout, tv.initialTimeout, tv.subscribeTimeout, tv.unconfiguredDelay, tv.configuredErrorDelay, tv.fixedDelay, tv.maxDelayMultiplier, random);
    }

    public long getSuccessTimeout() {
        return this.successTimeout;
    }

    public long getErrorTimeout() {
        return this.errorTimeout;
    }

    public long getInitialTimeout() {
        return this.initialTimeout;
    }

    public TimingValues setInitialTimeout(long t) {
        this.initialTimeout = t;
        return this;
    }

    public long getSubscribeTimeout() {
        return this.subscribeTimeout;
    }

    public TimingValues setSubscribeTimeout(long t) {
        this.subscribeTimeout = t;
        return this;
    }

    public long getConfiguredErrorTimeout() {
        return this.configuredErrorTimeout;
    }

    public TimingValues setConfiguredErrorTimeout(long t) {
        this.configuredErrorTimeout = t;
        return this;
    }

    public long getNextConfigTimeout() {
        return this.nextConfigTimeout;
    }

    public TimingValues setNextConfigTimeout(long t) {
        this.nextConfigTimeout = t;
        return this;
    }

    public long getUnconfiguredDelay() {
        return this.unconfiguredDelay;
    }

    public TimingValues setUnconfiguredDelay(long d) {
        this.unconfiguredDelay = d;
        return this;
    }

    public long getConfiguredErrorDelay() {
        return this.configuredErrorDelay;
    }

    public TimingValues setConfiguredErrorDelay(long d) {
        this.configuredErrorDelay = d;
        return this;
    }

    public int getMaxDelayMultiplier() {
        return this.maxDelayMultiplier;
    }

    public TimingValues setSuccessTimeout(long successTimeout) {
        this.successTimeout = successTimeout;
        return this;
    }

    public long getFixedDelay() {
        return this.fixedDelay;
    }

    public long getPlusMinusFractionRandom(long val, float fraction) {
        return Math.round((float)val - (float)val * fraction + this.rand.nextFloat() * 2.0f * (float)val * fraction);
    }

    Random getRandom() {
        return this.rand;
    }

    public String toString() {
        return "TimingValues [successTimeout=" + this.successTimeout + ", errorTimeout=" + this.errorTimeout + ", initialTimeout=" + this.initialTimeout + ", subscribeTimeout=" + this.subscribeTimeout + ", configuredErrorTimeout=" + this.configuredErrorTimeout + ", fixedDelay=" + this.fixedDelay + ", unconfiguredDelay=" + this.unconfiguredDelay + ", configuredErrorDelay=" + this.configuredErrorDelay + ", maxDelayMultiplier=" + this.maxDelayMultiplier + ", rand=" + this.rand + "]";
    }
}

