/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.Payload;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class JRTConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    private JRTConfigRequester requester;
    private TimingValues timingValues;
    private long lastOK = 0L;
    private LinkedBlockingQueue<JRTClientConfigRequest> reqQueue = new LinkedBlockingQueue();
    private ConfigSourceSet sources;

    public JRTConfigSubscription(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source, TimingValues timingValues) {
        super(key, subscriber);
        this.timingValues = timingValues;
        if (source instanceof ConfigSourceSet) {
            this.sources = (ConfigSourceSet)source;
        }
    }

    @Override
    public boolean nextConfig(long timeoutMillis) {
        boolean gotNew;
        ConfigSubscription.ConfigState configState = this.getConfigState();
        boolean bl = gotNew = configState.isGenerationChanged() || configState.isConfigChanged() || this.hasException();
        if (this.getReqQueue().peek() == null && gotNew) {
            return true;
        }
        if (!this.pollQueue(timeoutMillis)) {
            return gotNew;
        }
        configState = this.getConfigState();
        gotNew = configState.isGenerationChanged() || configState.isConfigChanged() || this.hasException();
        return gotNew;
    }

    private boolean pollQueue(long timeoutMillis) {
        JRTClientConfigRequest jrtReq;
        try {
            jrtReq = this.getReqQueue().poll(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            throw new ConfigInterruptedException(e1);
        }
        if (jrtReq == null) {
            return false;
        }
        if (jrtReq.hasUpdatedGeneration()) {
            this.setInternalRedeploy(jrtReq.responseIsInternalRedeploy());
            if (jrtReq.hasUpdatedConfig()) {
                this.setNewConfig(jrtReq);
            } else {
                this.setGeneration(jrtReq.getNewGeneration());
            }
        }
        return true;
    }

    protected void setNewConfig(JRTClientConfigRequest jrtReq) {
        IllegalArgumentException badConfigE = null;
        Object configInstance = null;
        try {
            configInstance = this.toConfigInstance(jrtReq);
        }
        catch (IllegalArgumentException e) {
            badConfigE = e;
        }
        this.setConfig(jrtReq.getNewGeneration(), jrtReq.responseIsInternalRedeploy(), configInstance);
        if (badConfigE != null) {
            throw new IllegalArgumentException("Bad config from jrt", badConfigE);
        }
    }

    private T toConfigInstance(JRTClientConfigRequest jrtRequest) {
        Payload payload = jrtRequest.getNewPayload();
        ConfigPayload configPayload = ConfigPayload.fromUtf8Array(payload.withCompression(CompressionType.UNCOMPRESSED).getData());
        Object configInstance = configPayload.toInstance(this.configClass, jrtRequest.getConfigKey().getConfigId());
        configInstance.setConfigMd5(jrtRequest.getNewConfigMd5());
        return (T)configInstance;
    }

    LinkedBlockingQueue<JRTClientConfigRequest> getReqQueue() {
        return this.reqQueue;
    }

    @Override
    public boolean subscribe(long timeout) {
        this.lastOK = System.currentTimeMillis();
        this.requester = this.getRequester();
        this.requester.request(this);
        JRTClientConfigRequest req = this.reqQueue.peek();
        while (req == null && System.currentTimeMillis() - this.lastOK <= timeout) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new ConfigInterruptedException(e);
            }
            req = this.reqQueue.peek();
        }
        return req != null;
    }

    private JRTConfigRequester getRequester() {
        JRTConfigRequester requester = this.subscriber.requesters().get(this.sources);
        if (requester == null) {
            requester = new JRTConfigRequester(new JRTConnectionPool(this.sources), this.timingValues);
            this.subscriber.requesters().put(this.sources, requester);
        }
        return requester;
    }

    @Override
    public void close() {
        super.close();
        this.reqQueue = new LinkedBlockingQueue<JRTClientConfigRequest>(){

            @Override
            public void put(JRTClientConfigRequest e) throws InterruptedException {
            }
        };
    }

    public TimingValues timingValues() {
        return this.timingValues;
    }

    public JRTConfigRequester requester() {
        return this.requester;
    }

    @Override
    public void reload(long generation) {
        log.log((Level)LogLevel.DEBUG, "reload() is without effect on a JRTConfigSubscription.");
    }

    void setLastCallBackOKTS(long lastCallBackOKTS) {
        this.lastOK = lastCallBackOKTS;
    }

    static void printStatus(JRTClientConfigRequest request, String message) {
        String name = request.getConfigKey().getName();
        if (name.equals("components") || name.equals("chains")) {
            log.log(LogLevel.INFO, message + ":" + name + ":, request=" + request);
        }
    }
}

