/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import java.io.IOException;
import java.io.OutputStream;

public interface ConfigResponse {
    public AbstractUtf8Array getPayload();

    public long getGeneration();

    public boolean applyOnRestart();

    public void serialize(OutputStream var1, CompressionType var2) throws IOException;

    default public boolean hasEqualConfig(JRTServerConfigRequest request) {
        PayloadChecksums payloadChecksums = this.getPayloadChecksums();
        PayloadChecksum xxhash64 = payloadChecksums.getForType(PayloadChecksum.Type.XXHASH64);
        PayloadChecksum md5 = payloadChecksums.getForType(PayloadChecksum.Type.MD5);
        if (xxhash64 != null) {
            return xxhash64.equals(request.getRequestConfigChecksums().getForType(PayloadChecksum.Type.XXHASH64));
        }
        if (md5 != null) {
            return md5.equals(request.getRequestConfigChecksums().getForType(PayloadChecksum.Type.MD5));
        }
        return true;
    }

    default public boolean hasNewerGeneration(JRTServerConfigRequest request) {
        return this.getGeneration() > request.getRequestGeneration();
    }

    public CompressionInfo getCompressionInfo();

    public PayloadChecksums getPayloadChecksums();
}

