/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.LeafCNode;
import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeFormat;
import com.yahoo.slime.Type;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;

public class ConfigFileFormat
implements SlimeFormat,
ObjectTraverser {
    private final InnerCNode root;
    private DataOutputStream out = null;
    private Stack<Node> nodeStack;

    public ConfigFileFormat(InnerCNode root) {
        this.root = root;
        this.nodeStack = new Stack();
    }

    private void printPrefix() throws IOException {
        for (Node node : this.nodeStack) {
            CNode cnode = node.node;
            if (cnode == this.root) continue;
            this.encodeString(cnode.getName());
            if (cnode.isArray) {
                this.encodeString("[" + node.arrayIndex + "]");
                if (cnode instanceof LeafCNode) continue;
                this.encodeString(".");
                continue;
            }
            if (cnode.isMap) {
                this.encodeString("{\"" + node.mapKey + "\"}");
                if (cnode instanceof LeafCNode) continue;
                this.encodeString(".");
                continue;
            }
            if (cnode instanceof LeafCNode) {
                this.encodeString("");
                continue;
            }
            this.encodeString(".");
        }
        this.encodeString(" ");
    }

    private void encode(Inspector inspector, CNode node) throws IOException {
        switch (inspector.type()) {
            case BOOL: {
                this.encodeValue(String.valueOf(inspector.asBool()), (LeafCNode)node);
                return;
            }
            case LONG: {
                this.encodeValue(String.valueOf(inspector.asLong()), (LeafCNode)node);
                return;
            }
            case DOUBLE: {
                this.encodeValue(String.valueOf(inspector.asDouble()), (LeafCNode)node);
                return;
            }
            case STRING: {
                this.encodeValue(inspector.asString(), (LeafCNode)node);
                return;
            }
            case ARRAY: {
                this.encodeArray(inspector, node);
                return;
            }
            case OBJECT: {
                if (node.isMap) {
                    this.encodeMap(inspector, node);
                } else {
                    this.encodeObject(inspector, node);
                }
                return;
            }
            case NIX: 
            case DATA: {
                throw new IllegalArgumentException("Illegal config format supplied. Unknown type for field '" + node.getName() + "'");
            }
        }
        throw new RuntimeException("Should not be reached");
    }

    private void encodeMap(Inspector inspector, final CNode node) {
        inspector.traverse(new ObjectTraverser(){

            public void field(String name, Inspector inspector) {
                try {
                    ConfigFileFormat.this.nodeStack.push(new Node(node, -1, name));
                    if (inspector.type().equals((Object)Type.OBJECT)) {
                        ConfigFileFormat.this.encodeObject(inspector, node);
                    } else {
                        ConfigFileFormat.this.encode(inspector, node);
                    }
                    ConfigFileFormat.this.nodeStack.pop();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void encodeArray(Inspector inspector, final CNode node) {
        inspector.traverse(new ArrayTraverser(){

            public void entry(int idx, Inspector inspector) {
                try {
                    ConfigFileFormat.this.nodeStack.push(new Node(node, idx, ""));
                    ConfigFileFormat.this.encode(inspector, node);
                    ConfigFileFormat.this.nodeStack.pop();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void encodeObject(Inspector inspector, CNode node) {
        if (!node.isArray && !node.isMap) {
            this.nodeStack.push(new Node(node));
            inspector.traverse((ObjectTraverser)this);
            this.nodeStack.pop();
        } else {
            inspector.traverse((ObjectTraverser)this);
        }
    }

    private void encodeValue(String value, LeafCNode node) throws IOException {
        this.printPrefix();
        try {
            if (node instanceof LeafCNode.StringLeaf) {
                this.encodeStringQuoted(value);
            } else if (node instanceof LeafCNode.IntegerLeaf) {
                this.encodeString(value);
            } else if (node instanceof LeafCNode.LongLeaf) {
                this.encodeString(value);
            } else if (node instanceof LeafCNode.DoubleLeaf) {
                this.encodeString(value);
            } else if (node instanceof LeafCNode.BooleanLeaf) {
                this.encodeString(String.valueOf(Boolean.parseBoolean(value)));
            } else if (node instanceof LeafCNode.EnumLeaf) {
                this.encodeString(value);
            } else {
                this.encodeStringQuoted(value);
            }
            this.encodeString("\n");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to serialize field '" + node.getFullName() + "': ", e);
        }
    }

    private void checkLegalEnumValue(LeafCNode.EnumLeaf enumNode, String value) {
        boolean found = false;
        for (String legalVal : enumNode.getLegalValues()) {
            if (!legalVal.equals(value)) continue;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Illegal enum value '" + value + "'");
        }
    }

    private void encodeStringQuoted(String s) throws IOException {
        this.encodeString("\"" + this.escapeString(s) + "\"");
    }

    private String escapeString(String s) {
        return ConfigUtils.escapeConfigFormatValue(s);
    }

    private void encodeString(String s) throws IOException {
        this.out.write(Utf8.toBytes((String)s));
    }

    public void encode(OutputStream os, Slime slime) throws IOException {
        this.encode(os, (Inspector)slime.get());
    }

    private void encode(OutputStream os, Inspector inspector) throws IOException {
        this.out = new DataOutputStream(os);
        this.nodeStack = new Stack();
        this.nodeStack.push(new Node((CNode)this.root));
        this.encode(inspector, (CNode)this.root);
    }

    @Deprecated(since="7", forRemoval=true)
    public void decode(InputStream is, Slime slime) throws IOException {
        throw new UnsupportedOperationException("decode is not supported");
    }

    public void field(String fieldName, Inspector inspector) {
        try {
            Node parent = this.nodeStack.peek();
            CNode child = parent.node.getChild(fieldName);
            if (child == null) {
                return;
            }
            if (!child.isArray && !child.isMap && child instanceof LeafCNode) {
                this.nodeStack.push(new Node(child));
                this.encode(inspector, child);
                this.nodeStack.pop();
            } else {
                this.encode(inspector, child);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class Node {
        final int arrayIndex;
        final String mapKey;
        final CNode node;

        Node(CNode node, int arrayIndex, String mapKey) {
            this.node = node;
            this.arrayIndex = arrayIndex;
            this.mapKey = mapKey;
        }

        Node(CNode node) {
            this(node, -1, "");
        }
    }
}

