/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequestV3;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.Optional;

public class JRTConfigRequestFactory {
    private static final CompressionType compressionType = JRTConfigRequestFactory.getCompressionType();
    private static final String VESPA_CONFIG_PROTOCOL_COMPRESSION = "VESPA_CONFIG_PROTOCOL_COMPRESSION";

    public static <T extends ConfigInstance> JRTClientConfigRequest createFromSub(JRTConfigSubscription<T> sub) {
        return JRTClientConfigRequestV3.createFromSub(sub, Trace.createNew(), compressionType, JRTConfigRequestFactory.getVespaVersion());
    }

    public static JRTClientConfigRequest createFromRaw(RawConfig config, long serverTimeout) {
        return JRTClientConfigRequestV3.createFromRaw(config, serverTimeout, Trace.createNew(), compressionType, JRTConfigRequestFactory.getVespaVersion());
    }

    public static CompressionType getCompressionType() {
        return JRTConfigRequestFactory.getCompressionType(System.getenv(VESPA_CONFIG_PROTOCOL_COMPRESSION), System.getProperty(VESPA_CONFIG_PROTOCOL_COMPRESSION));
    }

    static CompressionType getCompressionType(String env, String property) {
        return CompressionType.valueOf(ConfigUtils.getEnvValue("LZ4", env, property));
    }

    static Optional<VespaVersion> getVespaVersion() {
        return Optional.of(JRTConfigRequestFactory.getCompiledVespaVersion());
    }

    static VespaVersion getCompiledVespaVersion() {
        return VespaVersion.fromString(String.format("%d.%d.%d", 7, 469, 18));
    }
}

