/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.CfgConfigPayloadBuilder;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.PayloadChecksums;
import java.util.Arrays;

public class RawConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    final String inputPayload;
    String payload;

    RawConfigSubscription(ConfigKey<T> key, ConfigSubscriber subscriber, String pl) {
        super(key, subscriber);
        this.inputPayload = pl;
    }

    @Override
    public boolean nextConfig(long timeout) {
        if (this.checkReloaded()) {
            return true;
        }
        if (this.payload == null) {
            this.payload = this.inputPayload;
            ConfigPayload configPayload = new CfgConfigPayloadBuilder().deserialize(Arrays.asList(this.payload.split("\n")));
            this.setConfig(0L, false, configPayload.toInstance(this.configClass, this.key.getConfigId()), PayloadChecksums.empty());
            return true;
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new ConfigInterruptedException(e);
        }
        return false;
    }

    @Override
    public boolean subscribe(long timeout) {
        return true;
    }
}

