/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.jrt.Request;
import com.yahoo.text.Utf8Array;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.JRTMethods;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.protocol.SlimeClientConfigRequest;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.Optional;

public class JRTClientConfigRequestV3
extends SlimeClientConfigRequest {
    protected JRTClientConfigRequestV3(ConfigKey<?> key, String hostname, DefContent defSchema, String configMd5, long generation, long timeout, Trace trace, CompressionType compressionType, Optional<VespaVersion> vespaVersion) {
        super(key, hostname, defSchema, configMd5, generation, timeout, trace, compressionType, vespaVersion);
    }

    @Override
    protected String getJRTMethodName() {
        return "config.v3.getConfig";
    }

    @Override
    protected boolean checkReturnTypes(Request request) {
        return JRTMethods.checkV3ReturnTypes(request);
    }

    @Override
    public Payload getNewPayload() {
        CompressionInfo compressionInfo = this.getResponseData().getCompressionInfo();
        Utf8Array payload = new Utf8Array(this.request.returnValues().get(1).asData());
        return Payload.from(payload, compressionInfo);
    }

    @Override
    public long getProtocolVersion() {
        return 3L;
    }

    @Override
    public JRTClientConfigRequest nextRequest(long timeout) {
        return new JRTClientConfigRequestV3(this.getConfigKey(), this.getClientHostName(), this.getDefContent(), this.isError() ? this.getRequestConfigMd5() : this.newConfMd5(), this.isError() ? this.getRequestGeneration() : this.newGen(), timeout, Trace.createNew(), this.requestData.getCompressionType(), this.requestData.getVespaVersion());
    }

    public static <T extends ConfigInstance> JRTClientConfigRequest createFromSub(JRTConfigSubscription<T> sub, Trace trace, CompressionType compressionType, Optional<VespaVersion> vespaVersion) {
        String hostname = ConfigUtils.getCanonicalHostName();
        ConfigKey key = sub.getKey();
        ConfigSubscription.ConfigState configState = sub.getConfigState();
        Object i = configState.getConfig();
        return JRTClientConfigRequestV3.createWithParams(key, sub.getDefContent(), hostname, i != null ? i.getConfigMd5() : "", configState.getGeneration() != null ? configState.getGeneration() : 0L, sub.timingValues().getSubscribeTimeout(), trace, compressionType, vespaVersion);
    }

    public static JRTClientConfigRequest createFromRaw(RawConfig config, long serverTimeout, Trace trace, CompressionType compressionType, Optional<VespaVersion> vespaVersion) {
        String hostname = ConfigUtils.getCanonicalHostName();
        return JRTClientConfigRequestV3.createWithParams(config.getKey(), DefContent.fromList(config.getDefContent()), hostname, config.getConfigMd5(), config.getGeneration(), serverTimeout, trace, compressionType, vespaVersion);
    }

    public static JRTClientConfigRequest createWithParams(ConfigKey<?> reqKey, DefContent defContent, String hostname, String configMd5, long generation, long serverTimeout, Trace trace, CompressionType compressionType, Optional<VespaVersion> vespaVersion) {
        return new JRTClientConfigRequestV3(reqKey, hostname, defContent, configMd5, generation, serverTimeout, trace, compressionType, vespaVersion);
    }

    @Override
    public Optional<VespaVersion> getVespaVersion() {
        return this.requestData.getVespaVersion();
    }
}

