/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.buildergen;

import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;

class CompilationTask {
    private final JavaCompiler.CompilationTask task;
    private final DiagnosticCollector<JavaFileObject> diagnostics;

    CompilationTask(JavaCompiler.CompilationTask task, DiagnosticCollector<JavaFileObject> diagnostics) {
        this.task = task;
        this.diagnostics = diagnostics;
    }

    void call() {
        boolean success = this.task.call();
        if (!success) {
            throw new IllegalArgumentException("Compilation diagnostics: " + this.getDiagnosticMessage());
        }
    }

    private String getDiagnosticMessage() {
        StringBuilder diagnosticMessages = new StringBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : this.diagnostics.getDiagnostics()) {
            diagnosticMessages.append(diagnostic.getCode()).append("\n");
            diagnosticMessages.append((Object)diagnostic.getKind()).append("\n");
            diagnosticMessages.append(diagnostic.getPosition()).append("\n");
            diagnosticMessages.append(diagnostic.getStartPosition()).append("\n");
            diagnosticMessages.append(diagnostic.getEndPosition()).append("\n");
            diagnosticMessages.append(diagnostic.getSource()).append("\n");
            diagnosticMessages.append(diagnostic.getMessage(null)).append("\n");
        }
        return diagnosticMessages.toString();
    }
}

