/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.ConfigInstance;
import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class RawConfig
extends ConfigInstance {
    private final ConfigKey<?> key;
    private final String defMd5;
    private final List<String> defContent;
    private final Payload payload;
    private final int errorCode;
    private final String configMd5;
    private final Optional<VespaVersion> vespaVersion;
    private long generation;
    private boolean internalRedeploy;

    public RawConfig(ConfigKey<?> key, String defMd5) {
        this(key, defMd5, null, "", 0L, false, 0, Collections.emptyList(), Optional.empty());
    }

    public RawConfig(ConfigKey<?> key, String defMd5, Payload payload, String configMd5, long generation, boolean internalRedeploy, List<String> defContent, Optional<VespaVersion> vespaVersion) {
        this(key, defMd5, payload, configMd5, generation, internalRedeploy, 0, defContent, vespaVersion);
    }

    public RawConfig(RawConfig rawConfig) {
        this(rawConfig.key, rawConfig.defMd5, rawConfig.payload, rawConfig.configMd5, rawConfig.generation, rawConfig.internalRedeploy, rawConfig.errorCode, rawConfig.defContent, rawConfig.getVespaVersion());
    }

    public RawConfig(ConfigKey<?> key, String defMd5, Payload payload, String configMd5, long generation, boolean internalRedeploy, int errorCode, List<String> defContent, Optional<VespaVersion> vespaVersion) {
        this.key = key;
        this.defMd5 = ConfigUtils.getDefMd5FromRequest(defMd5, defContent);
        this.payload = payload;
        this.configMd5 = configMd5;
        this.generation = generation;
        this.internalRedeploy = internalRedeploy;
        this.errorCode = errorCode;
        this.defContent = defContent;
        this.vespaVersion = vespaVersion;
    }

    public static RawConfig createFromResponseParameters(JRTClientConfigRequest req) {
        return new RawConfig(req.getConfigKey(), req.getConfigKey().getMd5(), req.getNewPayload(), req.getNewConfigMd5(), req.getNewGeneration(), req.responseIsInternalRedeploy(), 0, req.getDefContent().asList(), req.getVespaVersion());
    }

    public static RawConfig createFromServerRequest(JRTServerConfigRequest req) {
        return new RawConfig(req.getConfigKey(), req.getConfigKey().getMd5(), Payload.from((Utf8Array)new Utf8String(""), CompressionInfo.uncompressed()), req.getRequestConfigMd5(), req.getRequestGeneration(), req.isInternalRedeploy(), 0, req.getDefContent().asList(), req.getVespaVersion());
    }

    public ConfigKey<?> getKey() {
        return this.key;
    }

    public String getName() {
        return this.key.getName();
    }

    public String getNamespace() {
        return this.key.getNamespace();
    }

    public String getConfigId() {
        return this.key.getConfigId();
    }

    public String getConfigMd5() {
        return this.configMd5;
    }

    public String getDefMd5() {
        return this.defMd5;
    }

    public long getGeneration() {
        return this.generation;
    }

    public void setGeneration(long generation) {
        this.generation = generation;
    }

    public boolean isInternalRedeploy() {
        return this.internalRedeploy;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public int errorCode() {
        return this.errorCode;
    }

    public String getDefNamespace() {
        return this.key.getNamespace();
    }

    public Optional<VespaVersion> getVespaVersion() {
        return this.vespaVersion;
    }

    public boolean hasEqualConfig(JRTServerConfigRequest req) {
        return this.getConfigMd5().equals(req.getRequestConfigMd5());
    }

    public boolean hasNewerGeneration(JRTServerConfigRequest req) {
        return this.getGeneration() > req.getRequestGeneration();
    }

    public boolean isError() {
        return this.errorCode() != 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawConfig)) {
            return false;
        }
        RawConfig other = (RawConfig)((Object)o);
        if (!this.key.equals(other.key) || !this.defMd5.equals(other.defMd5) || this.errorCode != other.errorCode) {
            return false;
        }
        if (this.isError()) {
            return true;
        }
        if (this.generation != other.generation) {
            return false;
        }
        if (this.configMd5 != null) {
            return this.configMd5.equals(other.configMd5);
        }
        return other.configMd5 == null;
    }

    public int hashCode() {
        int hash = 17;
        if (this.key != null) {
            hash = 31 * hash + this.key.hashCode();
        }
        if (this.defMd5 != null) {
            hash = 31 * hash + this.defMd5.hashCode();
        }
        hash = 31 * hash + this.errorCode;
        if (!this.isError()) {
            hash = 31 * hash + (int)(this.generation ^ this.generation >>> 32);
            if (this.configMd5 != null) {
                hash = 31 * hash + this.configMd5.hashCode();
            }
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.getNamespace()).append(".").append(this.key.getName());
        sb.append(",");
        sb.append(this.getDefMd5());
        sb.append(",");
        sb.append(this.key.getConfigId());
        sb.append(",");
        sb.append(this.getConfigMd5());
        sb.append(",");
        sb.append(this.getGeneration());
        sb.append(",");
        sb.append(this.getPayload());
        return sb.toString();
    }

    public List<String> getDefContent() {
        return this.defContent;
    }
}

