/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSet;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.DirSource;
import com.yahoo.config.subscription.FileSource;
import com.yahoo.config.subscription.JarSource;
import com.yahoo.config.subscription.RawSource;
import com.yahoo.config.subscription.impl.ConfigSetSubscription;
import com.yahoo.config.subscription.impl.FileConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.config.subscription.impl.JarConfigSubscription;
import com.yahoo.config.subscription.impl.RawConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.DefContent;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public abstract class ConfigSubscription<T extends ConfigInstance> {
    protected static Logger log = Logger.getLogger(ConfigSubscription.class.getName());
    protected final ConfigSubscriber subscriber;
    private final AtomicReference<ConfigState<T>> config = new AtomicReference();
    protected final ConfigKey<T> key;
    protected final Class<T> configClass;
    private volatile RuntimeException exception = null;
    private State state = State.OPEN;
    private final AtomicReference<Long> reloadedGeneration = new AtomicReference();

    ConfigSubscription(ConfigKey<T> key, ConfigSubscriber subscriber) {
        this.key = key;
        this.configClass = key.getConfigClass();
        this.subscriber = subscriber;
        this.config.set(new ConfigState());
    }

    public static <T extends ConfigInstance> ConfigSubscription<T> get(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source, TimingValues timingValues) {
        String configId = key.getConfigId();
        if (source instanceof RawSource || configId.startsWith("raw:")) {
            return ConfigSubscription.getRawSub(key, subscriber, source);
        }
        if (source instanceof FileSource || configId.startsWith("file:")) {
            return ConfigSubscription.getFileSub(key, subscriber, source);
        }
        if (source instanceof DirSource || configId.startsWith("dir:")) {
            return ConfigSubscription.getDirFileSub(key, subscriber, source);
        }
        if (source instanceof JarSource || configId.startsWith("jar:")) {
            return ConfigSubscription.getJarSub(key, subscriber, source);
        }
        if (source instanceof ConfigSet) {
            return new ConfigSetSubscription<T>(key, subscriber, source);
        }
        if (source instanceof ConfigSourceSet) {
            return new JRTConfigSubscription<T>(key, subscriber, source, timingValues);
        }
        throw new IllegalArgumentException("Unknown source type: " + source);
    }

    private static <T extends ConfigInstance> JarConfigSubscription<T> getJarSub(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source) {
        String jarName;
        String path = "config/";
        if (source instanceof JarSource) {
            JarSource js = (JarSource)source;
            jarName = js.getJarFile().getName();
            if (js.getPath() != null) {
                path = js.getPath();
            }
        } else {
            jarName = key.getConfigId().replace("jar:", "").replaceFirst("\\!/.*", "");
            if (key.getConfigId().contains("!/")) {
                path = key.getConfigId().replaceFirst(".*\\!/", "");
            }
        }
        return new JarConfigSubscription<T>(key, subscriber, jarName, path);
    }

    private static <T extends ConfigInstance> ConfigSubscription<T> getFileSub(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source) {
        File file = source instanceof FileSource ? ((FileSource)source).getFile() : new File(key.getConfigId().replace("file:", ""));
        return new FileConfigSubscription<T>(key, subscriber, file);
    }

    private static <T extends ConfigInstance> ConfigSubscription<T> getRawSub(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source) {
        String payload = source instanceof RawSource ? ((RawSource)source).payload : key.getConfigId().replace("raw:", "");
        return new RawConfigSubscription<T>(key, subscriber, payload);
    }

    private static <T extends ConfigInstance> ConfigSubscription<T> getDirFileSub(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source) {
        String dir = key.getConfigId().replace("dir:", "");
        if (source instanceof DirSource) {
            dir = ((DirSource)source).getDir().toString();
        }
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        String name = ConfigSubscription.getConfigFilenameNoVersion(key);
        File file = new File(dir + name);
        if (!file.exists()) {
            throw new IllegalArgumentException("Could not find a config file for '" + key.getName() + "' in '" + dir + "'");
        }
        return new FileConfigSubscription<T>(key, subscriber, file);
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigSubscription) {
            ConfigSubscription other = (ConfigSubscription)o;
            return this.key.equals(other.key) && this.subscriber.equals(other.subscriber);
        }
        return false;
    }

    public boolean isConfigChangedAndReset(Long requiredGen) {
        ConfigState<T> prev = this.config.get();
        while (prev.getGeneration().equals(requiredGen) && !this.config.compareAndSet(prev, ((ConfigState)prev).createUnchanged())) {
            prev = this.config.get();
        }
        return !prev.getGeneration().equals(requiredGen) || prev.isConfigChanged();
    }

    void setConfig(Long generation, T config) {
        this.config.set(new ConfigState(true, generation, false, true, (ConfigInstance)config, null));
    }

    protected void setConfigIncGen(T config) {
        ConfigState<T> prev = this.config.get();
        this.config.set(new ConfigState(true, prev.getGeneration() + 1L, prev.isInternalRedeploy(), true, (ConfigInstance)config, null));
    }

    protected void setConfigIfChanged(T config) {
        ConfigState<T> prev = this.config.get();
        this.config.set(new ConfigState(true, prev.getGeneration(), prev.isInternalRedeploy(), !config.equals(prev.getConfig()), (ConfigInstance)config, null));
    }

    void setGeneration(Long generation) {
        ConfigState<T> prev = this.config.get();
        this.config.set(new ConfigState(true, generation, prev.isInternalRedeploy(), prev.isConfigChanged(), (ConfigInstance)prev.getConfig(), null));
    }

    void setInternalRedeploy(boolean internalRedeploy) {
        ConfigState<T> prev = this.config.get();
        this.config.set(new ConfigState(prev.isGenerationChanged(), prev.getGeneration(), prev.isConfigChanged(), internalRedeploy, (ConfigInstance)prev.getConfig(), null));
    }

    public ConfigState<T> getConfigState() {
        return this.config.get();
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.key.toString());
        ConfigState<T> c = this.config.get();
        s.append(", Current generation: ").append(c.getGeneration()).append(", Generation changed: ").append(c.isGenerationChanged()).append(", Config changed: ").append(c.isConfigChanged());
        if (this.exception != null) {
            s.append(", Exception: ").append(this.exception);
        }
        return s.toString();
    }

    public ConfigKey<T> getKey() {
        return this.key;
    }

    public abstract boolean nextConfig(long var1);

    public abstract boolean subscribe(long var1);

    public void setException(RuntimeException e) {
        this.exception = e;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    boolean hasException() {
        return this.exception != null;
    }

    public void close() {
        this.state = State.CLOSED;
    }

    State getState() {
        return this.state;
    }

    static <T extends ConfigInstance> String getConfigFilenameNoVersion(ConfigKey<T> key) {
        StringBuilder filename = new StringBuilder(key.getName());
        filename.append(".cfg");
        return filename.toString();
    }

    public void reload(long generation) {
        this.reloadedGeneration.set(generation);
    }

    protected boolean checkReloaded() {
        Long reloaded = this.reloadedGeneration.getAndSet(null);
        if (reloaded != null) {
            this.setGeneration(reloaded);
            return true;
        }
        return false;
    }

    public DefContent getDefContent() {
        return DefContent.fromClass(this.configClass);
    }

    static enum State {
        OPEN,
        CLOSED;

    }

    public static class ConfigState<T extends ConfigInstance> {
        private final boolean configChanged;
        private final boolean generationChanged;
        private final T config;
        private final Long generation;
        private final boolean internalRedeploy;

        private ConfigState(boolean generationChanged, Long generation, boolean internalRedeploy, boolean configChanged, T config) {
            this.generationChanged = generationChanged;
            this.generation = generation;
            this.internalRedeploy = internalRedeploy;
            this.configChanged = configChanged;
            this.config = config;
        }

        private ConfigState(Long generation, T config) {
            this(false, generation, false, false, config);
        }

        private ConfigState() {
            this(false, 0L, false, false, null);
        }

        private ConfigState<T> createUnchanged() {
            return new ConfigState<T>(this.generation, this.config);
        }

        public boolean isConfigChanged() {
            return this.configChanged;
        }

        public boolean isGenerationChanged() {
            return this.generationChanged;
        }

        public Long getGeneration() {
            return this.generation;
        }

        public boolean isInternalRedeploy() {
            return this.internalRedeploy;
        }

        public T getConfig() {
            return this.config;
        }

        /* synthetic */ ConfigState(boolean x0, Long x1, boolean x2, boolean x3, ConfigInstance x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }
    }
}

