/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigHandle;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.yolean.Exceptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigSubscriber {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private State state = State.OPEN;
    protected List<ConfigHandle<? extends ConfigInstance>> subscriptionHandles = new ArrayList<ConfigHandle<? extends ConfigInstance>>();
    private final ConfigSource source;
    private long generation = -1L;
    private boolean internalRedeploy = false;
    protected Map<ConfigSourceSet, JRTConfigRequester> requesters = new HashMap<ConfigSourceSet, JRTConfigRequester>();

    public ConfigSubscriber() {
        this(JRTConfigRequester.defaultSourceSet);
    }

    public ConfigSubscriber(ConfigSource source) {
        this.source = source;
    }

    public <T extends ConfigInstance> ConfigHandle<T> subscribe(Class<T> configClass, String configId) {
        return this.subscribe(configClass, configId, this.source, new TimingValues());
    }

    public <T extends ConfigInstance> ConfigHandle<T> subscribe(Class<T> configClass, String configId, long timeoutMillis) {
        return this.subscribe(configClass, configId, this.source, new TimingValues().setSubscribeTimeout(timeoutMillis));
    }

    <T extends ConfigInstance> ConfigHandle<T> subscribe(Class<T> configClass, String configId, ConfigSource source, TimingValues timingValues) {
        this.checkStateBeforeSubscribe();
        ConfigKey<T> configKey = new ConfigKey<T>(configClass, configId);
        ConfigSubscription<T> sub = ConfigSubscription.get(configKey, this, source, timingValues);
        ConfigHandle<T> handle = new ConfigHandle<T>(sub);
        this.subscribeAndHandleErrors(sub, configKey, handle, timingValues);
        return handle;
    }

    protected void checkStateBeforeSubscribe() {
        if (this.state != State.OPEN) {
            throw new IllegalStateException("Adding subscription after calling nextConfig() is not allowed");
        }
    }

    protected void subscribeAndHandleErrors(ConfigSubscription<?> sub, ConfigKey<?> configKey, ConfigHandle<?> handle, TimingValues timingValues) {
        this.subscriptionHandles.add(handle);
        boolean subOk = sub.subscribe(timingValues.getSubscribeTimeout());
        this.throwIfExceptionSet(sub);
        if (!subOk) {
            throw new ConfigurationRuntimeException("Subscribe for '" + configKey + "' timed out (timeout was " + timingValues.getSubscribeTimeout() + " ms): " + sub);
        }
    }

    public boolean nextConfig() {
        return this.nextConfig(1000L);
    }

    public boolean nextConfig(long timeoutMillis) {
        return this.acquireSnapshot(timeoutMillis, true);
    }

    public boolean nextGeneration() {
        return this.nextGeneration(1000L);
    }

    public boolean nextGeneration(long timeoutMillis) {
        return this.acquireSnapshot(timeoutMillis, false);
    }

    private boolean acquireSnapshot(long timeoutInMillis, boolean requireChange) {
        boolean reconfigDue;
        if (this.state == State.CLOSED) {
            return false;
        }
        long started = System.currentTimeMillis();
        long timeLeftMillis = timeoutInMillis;
        this.state = State.FROZEN;
        boolean anyConfigChanged = false;
        boolean allGenerationsChanged = true;
        boolean allGenerationsTheSame = true;
        Long currentGen = null;
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            h.setChanged(false);
        }
        boolean internalRedeployOnly = true;
        do {
            for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
                ConfigSubscription<? extends ConfigInstance> subscription = h.subscription();
                if (!subscription.nextConfig(timeLeftMillis)) {
                    return false;
                }
                this.throwIfExceptionSet(subscription);
                ConfigSubscription.ConfigState<? extends ConfigInstance> config = subscription.getConfigState();
                if (currentGen == null) {
                    currentGen = config.getGeneration();
                }
                if (!currentGen.equals(config.getGeneration())) {
                    allGenerationsTheSame = false;
                }
                boolean bl = allGenerationsChanged = allGenerationsChanged && config.isGenerationChanged();
                if (config.isConfigChanged()) {
                    anyConfigChanged = true;
                }
                internalRedeployOnly = internalRedeployOnly && config.isInternalRedeploy();
                timeLeftMillis -= System.currentTimeMillis() - started;
            }
            boolean bl = reconfigDue = (anyConfigChanged || !requireChange) && allGenerationsChanged && allGenerationsTheSame;
            if (reconfigDue || timeLeftMillis <= 0L) continue;
            this.sleep();
        } while (!reconfigDue && timeLeftMillis > 0L);
        if (reconfigDue) {
            this.markSubsChangedSeen(currentGen);
            this.internalRedeploy = internalRedeployOnly;
            this.generation = currentGen;
        }
        return reconfigDue;
    }

    private void sleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            throw new ConfigInterruptedException(e);
        }
    }

    protected void throwIfExceptionSet(ConfigSubscription<? extends ConfigInstance> sub) {
        RuntimeException subThrowable = sub.getException();
        if (subThrowable != null) {
            sub.setException(null);
            throw subThrowable;
        }
    }

    private void markSubsChangedSeen(Long requiredGen) {
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            ConfigSubscription<? extends ConfigInstance> sub = h.subscription();
            h.setChanged(sub.isConfigChangedAndReset(requiredGen));
        }
    }

    public void close() {
        this.state = State.CLOSED;
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            h.subscription().close();
        }
        this.closeRequesters();
        this.log.log((Level)LogLevel.DEBUG, "Config subscriber has been closed.");
    }

    protected void closeRequesters() {
        for (JRTConfigRequester requester : this.requesters.values()) {
            requester.close();
        }
    }

    public String toString() {
        String ret = "Subscriber state:" + (Object)((Object)this.state);
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            ret = ret + "\n" + h.toString();
        }
        return ret;
    }

    public Thread startConfigThread(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setDaemon(true);
        t.setName("Vespa config thread");
        t.start();
        return t;
    }

    protected State state() {
        return this.state;
    }

    public void reload(long generation) {
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            h.subscription().reload(generation);
        }
    }

    public ConfigSource getSource() {
        return this.source;
    }

    public Map<ConfigSourceSet, JRTConfigRequester> requesters() {
        return this.requesters;
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public <T extends ConfigInstance> ConfigHandle<T> subscribe(final SingleSubscriber<T> singleSubscriber, Class<T> configClass, String configId) {
        if (!this.subscriptionHandles.isEmpty()) {
            throw new IllegalStateException("Can not start single-subscription because subscriptions were previously opened on this.");
        }
        final ConfigHandle<T> handle = this.subscribe(configClass, configId);
        if (!this.nextConfig()) {
            throw new ConfigurationRuntimeException("Initial config of " + configClass.getName() + " failed.");
        }
        singleSubscriber.configure(handle.getConfig());
        this.startConfigThread(new Runnable(){

            @Override
            public void run() {
                while (!ConfigSubscriber.this.isClosed()) {
                    try {
                        if (!ConfigSubscriber.this.nextConfig() || !handle.isChanged()) continue;
                        singleSubscriber.configure(handle.getConfig());
                    }
                    catch (Exception e) {
                        ConfigSubscriber.this.log.log((Level)LogLevel.ERROR, "Exception from config system, continuing config thread: " + Exceptions.toMessageString((Throwable)e));
                    }
                }
            }
        });
        return handle;
    }

    public long getGeneration() {
        return this.generation;
    }

    public boolean isInternalRedeploy() {
        return this.internalRedeploy;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed()) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static interface SingleSubscriber<T extends ConfigInstance> {
        public void configure(T var1);
    }

    protected static enum State {
        OPEN,
        FROZEN,
        CLOSED;

    }
}

