/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.NoCopyByteArrayOutputStream;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.protocol.SlimeServerConfigRequest;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.IOException;
import java.util.logging.Level;

public class JRTServerConfigRequestV3
extends SlimeServerConfigRequest {
    protected JRTServerConfigRequestV3(Request request) {
        super(request);
    }

    @Override
    public void addOkResponse(Payload payload, long generation, String configMd5) {
        boolean changedConfig = !configMd5.equals(this.getRequestConfigMd5());
        boolean changedConfigAndNewGeneration = changedConfig && ConfigUtils.isGenerationNewer(generation, this.getRequestGeneration());
        Payload responsePayload = payload.withCompression(this.getCompressionType());
        NoCopyByteArrayOutputStream byteArrayOutputStream = new NoCopyByteArrayOutputStream(4096);
        try {
            JsonGenerator jsonGenerator = JRTServerConfigRequestV3.createJsonGenerator(byteArrayOutputStream);
            jsonGenerator.writeStartObject();
            this.addCommonReturnValues(jsonGenerator);
            JRTServerConfigRequestV3.setResponseField(jsonGenerator, "configMD5", configMd5);
            JRTServerConfigRequestV3.setResponseField(jsonGenerator, "generation", generation);
            jsonGenerator.writeObjectFieldStart("compressionInfo");
            if (responsePayload == null) {
                throw new RuntimeException("Payload is null for ' " + this + ", not able to create response");
            }
            CompressionInfo compressionInfo = responsePayload.getCompressionInfo();
            if (!changedConfigAndNewGeneration) {
                compressionInfo = CompressionInfo.create(compressionInfo.getCompressionType(), 0);
            }
            compressionInfo.serialize(jsonGenerator);
            jsonGenerator.writeEndObject();
            if (log.isLoggable((Level)LogLevel.SPAM)) {
                log.log((Level)LogLevel.SPAM, this.getConfigKey() + ": response dataXXXXX" + payload.withCompression(CompressionType.UNCOMPRESSED) + "XXXXX");
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not add OK response for " + this);
        }
        this.request.returnValues().add(JRTServerConfigRequestV3.createResponseValue(byteArrayOutputStream));
        if (changedConfigAndNewGeneration) {
            this.request.returnValues().add((Value)new DataValue(responsePayload.getData().getBytes()));
        } else {
            this.request.returnValues().add((Value)new DataValue(new byte[0]));
        }
    }

    @Override
    public long getProtocolVersion() {
        return 3L;
    }

    public static JRTServerConfigRequestV3 createFromRequest(Request req) {
        return new JRTServerConfigRequestV3(req);
    }
}

