/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.yahoo.vespa.config.proxy.filedistribution.DownloadOptions;
import com.yahoo.vespa.config.proxy.filedistribution.RequestTracker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.util.Timeout;

class UrlDownloader {
    private static final Logger log = Logger.getLogger(UrlDownloader.class.getName());
    private static final String CONTENTS_FILE_NAME = "contents";
    private static final String USER_AGENT_MODEL_DOWNLOADER = "Vespa/8.x (model download - https://github.com/vespa-engine/vespa)";
    private final URI uri;
    private final DownloadOptions downloadOptions;
    private final HttpClient httpClient = UrlDownloader.createClient();

    public UrlDownloader(URI uri, DownloadOptions downloadOptions) {
        this.uri = uri;
        this.downloadOptions = downloadOptions;
    }

    public Optional<File> download(File downloadDir) throws IOException {
        long start = System.currentTimeMillis();
        log.log(Level.INFO, "Downloading URL '" + String.valueOf(this.uri) + "'");
        Path tempFile = Files.createTempFile(downloadDir.toPath(), this.fileName(), "inprogress", new FileAttribute[0]);
        Path target = downloadDir.toPath().resolve(this.fileName());
        HttpGet get = new HttpGet(this.uri);
        this.downloadOptions.getAuthToken().ifPresent(token -> get.setHeader((Header)new BasicHeader("Authorization", (Object)("Bearer " + token))));
        return (Optional)this.httpClient.execute((ClassicHttpRequest)get, resp -> {
            int code = resp.getCode();
            if (code != 200) {
                throw new RuntimeException("Download of URL '" + String.valueOf(this.uri) + "' failed, got response code " + code);
            }
            return this.writeContent(downloadDir, resp, tempFile, target, start);
        });
    }

    private Optional<File> writeContent(File downloadDir, ClassicHttpResponse resp, Path tempFile, Path target, long start) throws IOException {
        InputStream content = resp.getEntity().getContent();
        if (content == null) {
            return Optional.empty();
        }
        try (InputStream in = content;){
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
            if (Files.exists(tempFile, new LinkOption[0]) && Files.size(tempFile) > 0L) {
                Files.move(tempFile, target, new CopyOption[0]);
                new RequestTracker().trackRequest(downloadDir);
                log.log(Level.FINE, () -> "URL '" + String.valueOf(this.uri) + "' available at " + String.valueOf(target));
                log.log(Level.INFO, String.format("Download of URL '%s' done in %.3f seconds", this.uri, (double)(System.currentTimeMillis() - start) / 1000.0));
                Optional<File> optional = Optional.of(target.toFile());
                return optional;
            }
            log.log(Level.SEVERE, "Downloaded URL '" + String.valueOf(this.uri) + "' not found, returning error");
            Optional<File> optional = Optional.empty();
            return optional;
        }
    }

    public String fileName() {
        String path = this.uri.getPath();
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        return fileName.isEmpty() ? CONTENTS_FILE_NAME : fileName;
    }

    boolean alreadyDownloaded(File downloadDir) {
        File contents = new File(downloadDir, this.fileName());
        return contents.exists() && contents.length() > 0L;
    }

    private static HttpClient createClient() {
        return HttpClientBuilder.create().setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy()).setUserAgent(USER_AGENT_MODEL_DOWNLOADER).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)30L)).setResponseTimeout(Timeout.ofSeconds((long)30L)).build()).build();
    }
}

