/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.proxy.filedistribution.FileDistributionRpcServer;
import com.yahoo.vespa.config.proxy.filedistribution.FileReferencesAndDownloadsMaintainer;
import com.yahoo.vespa.config.proxy.filedistribution.UrlDownloadRpcServer;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import java.time.Duration;

public class FileDistributionAndUrlDownload {
    private final FileDistributionRpcServer fileDistributionRpcServer;
    private final UrlDownloadRpcServer urlDownloadRpcServer;
    private final FileReferencesAndDownloadsMaintainer maintainer;

    public FileDistributionAndUrlDownload(Supervisor supervisor, ConfigSourceSet source) {
        this.fileDistributionRpcServer = new FileDistributionRpcServer(supervisor, this.createDownloader(supervisor, source));
        this.urlDownloadRpcServer = new UrlDownloadRpcServer(supervisor);
        this.maintainer = new FileReferencesAndDownloadsMaintainer();
    }

    public void close() {
        this.fileDistributionRpcServer.close();
        this.urlDownloadRpcServer.close();
        this.maintainer.close();
    }

    private FileDownloader createDownloader(Supervisor supervisor, ConfigSourceSet source) {
        return new FileDownloader((ConnectionPool)new FileDistributionConnectionPool(source, supervisor), supervisor, Duration.ofSeconds(55L));
    }
}

