/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.config.subscription.impl.GenericConfigHandle;
import com.yahoo.config.subscription.impl.GenericConfigSubscriber;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.protect.Process;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.yolean.Exceptions;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Subscriber {
    private static final Logger log = Logger.getLogger(Subscriber.class.getName());
    private final RawConfig config;
    private final TimingValues timingValues;
    private final GenericConfigSubscriber subscriber;
    private GenericConfigHandle handle;

    Subscriber(RawConfig config, TimingValues timingValues, JRTConfigRequester requester) {
        this.config = config;
        this.timingValues = timingValues;
        this.subscriber = new GenericConfigSubscriber(requester);
    }

    void subscribe() {
        ConfigKey key = this.config.getKey();
        this.handle = this.subscriber.subscribe(new ConfigKey(key.getName(), key.getConfigId(), key.getNamespace()), this.config.getDefContent(), this.timingValues);
    }

    public Optional<RawConfig> nextGeneration() {
        try {
            if (this.subscriber.nextGeneration(0L, true)) {
                RawConfig rawConfig = this.handle.getRawConfig();
                if (rawConfig == null) {
                    log.log(Level.SEVERE, "Config for " + String.valueOf(this.config.getKey()) + " is null");
                }
                return Optional.ofNullable(rawConfig);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Got exception: " + Exceptions.toMessageString((Throwable)e));
        }
        catch (Throwable e) {
            Process.logAndDie((String)("Got error, exiting: " + Exceptions.toMessageString((Throwable)e)));
        }
        return Optional.empty();
    }

    public void cancel() {
        this.subscriber.close();
    }

    boolean isClosed() {
        return this.subscriber.isClosed();
    }
}

