/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.io.IOUtils;
import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemoryCache {
    private static final Logger log = Logger.getLogger(MemoryCache.class.getName());
    private static final String separator = ":";
    private static final String DEFAULT_DUMP_DIR = Defaults.getDefaults().underVespaHome("var/vespa/cache/config");
    private final ConcurrentHashMap<ConfigCacheKey, RawConfig> cache = new ConcurrentHashMap(500, 0.75f);

    public Optional<RawConfig> get(ConfigCacheKey key) {
        return Optional.ofNullable(this.cache.get(key));
    }

    public void update(RawConfig config) {
        if (config.isError()) {
            return;
        }
        if (config.getGeneration() == 0L) {
            this.cache.clear();
            return;
        }
        log.log(Level.FINE, () -> "Putting '" + config + "' into memory cache");
        this.cache.put(new ConfigCacheKey(config.getKey(), config.getDefMd5()), config);
    }

    boolean containsKey(ConfigCacheKey key) {
        return this.cache.containsKey(key);
    }

    Collection<RawConfig> values() {
        return this.cache.values();
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }

    public String toString() {
        return this.cache.toString();
    }

    String dumpCacheToDisk(String path, MemoryCache cache) {
        File dir;
        if (path == null || path.isEmpty()) {
            path = DEFAULT_DUMP_DIR;
            log.log(Level.INFO, "dumpCache. No path or empty path. Using '" + path + "'");
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!(dir = new File(path)).exists()) {
            log.log(Level.INFO, dir.getAbsolutePath() + " does not exist, creating it");
            try {
                Files.createDirectory(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                return "Failed creating '" + dir.getAbsolutePath() + "', " + e.getClass().getSimpleName();
            }
        }
        if (!dir.isDirectory()) {
            return "Not a directory: '" + dir.getAbsolutePath() + "'";
        }
        if (!dir.canWrite()) {
            return "Not able to write to '" + dir.getAbsolutePath() + "'";
        }
        log.log(Level.INFO, "Dumping cache to '" + dir.getAbsolutePath() + "'");
        for (RawConfig config : cache.values()) {
            this.writeConfigToFile(config, path);
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigToFile(RawConfig config, String path) {
        String filename = path + File.separator + MemoryCache.createCacheFileName(config);
        Writer writer = null;
        try {
            log.log(Level.FINE, () -> "Writing '" + config.getKey() + "' to '" + filename + "'");
            Payload payload = config.getPayload();
            long protocolVersion = 3L;
            log.log(Level.FINE, () -> "Writing config '" + config + "' to file '" + filename + "' with protocol version " + protocolVersion);
            writer = IOUtils.createWriter((String)filename, (String)"UTF-8", (boolean)false);
            writer.write("# defMd5:" + config.getDefMd5() + "\n");
            writer.write("# config checksums:" + config.getPayloadChecksums() + "\n");
            writer.write("# generation:" + config.getGeneration() + "\n");
            writer.write("# protocolVersion:" + protocolVersion + "\n");
            writer.write("\n");
            writer.write(payload.withCompression(CompressionType.UNCOMPRESSED).toString());
            writer.write("\n");
            writer.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not write to file '" + filename + "'");
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String createCacheFileName(RawConfig config) {
        return MemoryCache.createCacheFileName(new ConfigCacheKey(config.getKey(), config.getDefMd5()));
    }

    private static String createCacheFileName(ConfigCacheKey key) {
        ConfigKey configKey = key.getKey();
        return configKey.getNamespace() + "." + configKey.getName() + separator + configKey.getConfigId().replaceAll("/", "_") + separator + key.getDefMd5();
    }
}

