/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.proxy.filedistribution.CachedFilesMaintainer;
import com.yahoo.vespa.config.proxy.filedistribution.FileDistributionRpcServer;
import com.yahoo.vespa.config.proxy.filedistribution.UrlDownloadRpcServer;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class FileDistributionAndUrlDownload {
    private static final Duration delay = Duration.ofMinutes(1L);
    private final FileDistributionRpcServer fileDistributionRpcServer;
    private final UrlDownloadRpcServer urlDownloadRpcServer;
    private final ScheduledExecutorService cleanupExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("file references and downloads cleanup"));

    public FileDistributionAndUrlDownload(Supervisor supervisor, ConfigSourceSet source) {
        this.fileDistributionRpcServer = new FileDistributionRpcServer(supervisor, this.createDownloader(supervisor, source));
        this.urlDownloadRpcServer = new UrlDownloadRpcServer(supervisor);
        this.cleanupExecutor.scheduleAtFixedRate(new CachedFilesMaintainer(), delay.toSeconds(), delay.toSeconds(), TimeUnit.SECONDS);
    }

    public void close() {
        this.fileDistributionRpcServer.close();
        this.urlDownloadRpcServer.close();
        this.cleanupExecutor.shutdownNow();
        try {
            if (!this.cleanupExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Unable to shutdown " + this.cleanupExecutor + " before timeout");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private FileDownloader createDownloader(Supervisor supervisor, ConfigSourceSet source) {
        return new FileDownloader((ConnectionPool)new FileDistributionConnectionPool(source, supervisor), supervisor, Duration.ofMinutes(5L));
    }
}

