/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.log.LogSetup;
import com.yahoo.log.event.Event;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.proxy.ConfigProxyRpcServer;
import com.yahoo.vespa.config.proxy.ConfigSourceClient;
import com.yahoo.vespa.config.proxy.DelayedResponses;
import com.yahoo.vespa.config.proxy.MemoryCache;
import com.yahoo.vespa.config.proxy.MemoryCacheConfigClient;
import com.yahoo.vespa.config.proxy.Mode;
import com.yahoo.vespa.config.proxy.RpcConfigSourceClient;
import com.yahoo.vespa.config.proxy.RpcServer;
import com.yahoo.vespa.config.proxy.filedistribution.FileDistributionAndUrlDownload;
import com.yahoo.yolean.system.CatchSignals;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyServer
implements Runnable {
    private static final DaemonThreadFactory threadFactory = new DaemonThreadFactory("ProxyServer");
    private static final int DEFAULT_RPC_PORT = 19090;
    private static final int JRT_TRANSPORT_THREADS = 4;
    static final String DEFAULT_PROXY_CONFIG_SOURCES = "tcp/localhost:19070";
    private static final Logger log = Logger.getLogger(ProxyServer.class.getName());
    private final AtomicBoolean signalCaught = new AtomicBoolean(false);
    private final Supervisor supervisor;
    private final ConfigProxyRpcServer rpcServer;
    private ConfigSourceSet configSource;
    private volatile ConfigSourceClient configClient;
    private final MemoryCache memoryCache;
    private final FileDistributionAndUrlDownload fileDistributionAndUrlDownload;
    private volatile Mode mode = new Mode(Mode.ModeName.DEFAULT);

    ProxyServer(Spec spec, ConfigSourceSet source, MemoryCache memoryCache, ConfigSourceClient configClient) {
        this.configSource = source;
        this.supervisor = new Supervisor(new Transport("proxy-server", 4)).setDropEmptyBuffers(true);
        log.log(Level.FINE, () -> "Using config source '" + source);
        this.memoryCache = memoryCache;
        this.rpcServer = this.createRpcServer(spec);
        this.configClient = configClient == null ? ProxyServer.createRpcClient(this.rpcServer, source, memoryCache) : configClient;
        this.fileDistributionAndUrlDownload = new FileDistributionAndUrlDownload(this.supervisor, source);
    }

    @Override
    public void run() {
        if (this.rpcServer != null) {
            Thread t = threadFactory.newThread((Runnable)this.rpcServer);
            t.setName("RpcServer");
            t.start();
        }
    }

    RawConfig resolveConfig(JRTServerConfigRequest req) {
        return this.configClient.getConfig(RawConfig.createFromServerRequest((JRTServerConfigRequest)req), req);
    }

    static boolean configOrGenerationHasChanged(RawConfig config, JRTServerConfigRequest request) {
        return config != null && (!config.hasEqualConfig(request) || config.hasNewerGeneration(request));
    }

    Mode getMode() {
        return this.mode;
    }

    void setMode(String modeName) {
        if (modeName.equals(this.mode.name())) {
            return;
        }
        Mode oldMode = this.mode;
        Mode newMode = new Mode(modeName);
        switch (newMode.getMode()) {
            case MEMORYCACHE: {
                this.configClient.shutdownSourceConnections();
                this.configClient = new MemoryCacheConfigClient(this.memoryCache);
                this.mode = new Mode(modeName);
                break;
            }
            case DEFAULT: {
                this.flush();
                this.configClient = ProxyServer.createRpcClient(this.rpcServer, this.configSource, this.memoryCache);
                this.mode = new Mode(modeName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot set invalid mode '" + modeName + "'");
            }
        }
        log.log(Level.INFO, "Switched from '" + oldMode.name().toLowerCase() + "' mode to '" + this.getMode().name().toLowerCase() + "' mode");
    }

    private ConfigProxyRpcServer createRpcServer(Spec spec) {
        return spec == null ? null : new ConfigProxyRpcServer(this, this.supervisor, spec);
    }

    private static RpcConfigSourceClient createRpcClient(RpcServer rpcServer, ConfigSourceSet source, MemoryCache memoryCache) {
        return new RpcConfigSourceClient(rpcServer, source, memoryCache);
    }

    private void setupSignalHandler() {
        CatchSignals.setup((AtomicBoolean)this.signalCaught);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForShutdown() {
        AtomicBoolean atomicBoolean = this.signalCaught;
        synchronized (atomicBoolean) {
            while (!this.signalCaught.get()) {
                try {
                    this.signalCaught.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
        Callable<String> stopper = () -> {
            this.stop();
            return "clean shutdown";
        };
        Future<String> future = executor.submit(stopper);
        try {
            String result = future.get(5L, TimeUnit.SECONDS);
            Event.stopping((String)"configproxy", (String)result);
        }
        catch (Exception e) {
            System.exit(1);
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        LogSetup.clearHandlers();
        LogSetup.initVespaLogging((String)"configproxy");
        Properties properties = ProxyServer.getSystemProperties();
        int port = 19090;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        Event.started((String)"configproxy");
        ConfigSourceSet configSources = new ConfigSourceSet(properties.configSources);
        ProxyServer proxyServer = new ProxyServer(new Spec(null, port), configSources, new MemoryCache(), null);
        proxyServer.setupSignalHandler();
        Thread proxyserverThread = threadFactory.newThread((Runnable)proxyServer);
        proxyserverThread.setName("configproxy");
        proxyserverThread.start();
        proxyServer.waitForShutdown();
    }

    static Properties getSystemProperties() {
        String[] inputConfigSources = System.getProperty("proxyconfigsources", DEFAULT_PROXY_CONFIG_SOURCES).split(",");
        return new Properties(inputConfigSources);
    }

    private synchronized void flush() {
        this.memoryCache.clear();
        this.configClient.cancel();
    }

    void stop() {
        Event.stopping((String)"configproxy", (String)"shutdown rpcServer");
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
        }
        Event.stopping((String)"configproxy", (String)"cancel configClient");
        if (this.configClient != null) {
            this.configClient.cancel();
        }
        Event.stopping((String)"configproxy", (String)"flush");
        this.flush();
        Event.stopping((String)"configproxy", (String)"close fileDistribution");
        this.fileDistributionAndUrlDownload.close();
        Event.stopping((String)"configproxy", (String)"stop complete");
    }

    MemoryCache getMemoryCache() {
        return this.memoryCache;
    }

    String getActiveSourceConnection() {
        return this.configClient.getActiveSourceConnection();
    }

    List<String> getSourceConnections() {
        return this.configClient.getSourceConnections();
    }

    void updateSourceConnections(List<String> sources) {
        this.configSource = new ConfigSourceSet(sources);
        this.flush();
        this.configClient = ProxyServer.createRpcClient(this.rpcServer, this.configSource, this.memoryCache);
    }

    DelayedResponses delayedResponses() {
        return this.configClient.delayedResponses();
    }

    static class Properties {
        final String[] configSources;

        Properties(String[] configSources) {
            this.configSources = configSources;
        }
    }
}

