/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import java.io.File;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;

class RequestTracker {
    private static final Logger log = Logger.getLogger(RequestTracker.class.getName());

    RequestTracker() {
    }

    void trackRequest(File file) {
        String absolutePath = file.getAbsolutePath();
        if (!file.exists()) {
            log.log(Level.WARNING, "Could not find file '" + absolutePath + "'");
        }
        if (!file.setLastModified(Instant.now().toEpochMilli())) {
            log.log(Level.WARNING, "Could not set last modified timestamp for '" + absolutePath + "'");
        }
    }
}

