/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.impl.GenericConfigHandle;
import com.yahoo.config.subscription.impl.GenericConfigSubscriber;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.log.LogLevel;
import com.yahoo.protect.Process;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.proxy.ConfigSourceClient;
import com.yahoo.vespa.config.proxy.MemoryCache;
import com.yahoo.vespa.config.proxy.Subscriber;
import com.yahoo.yolean.Exceptions;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpstreamConfigSubscriber
implements Subscriber {
    private static final Logger log = Logger.getLogger(UpstreamConfigSubscriber.class.getName());
    private final RawConfig config;
    private final ConfigSourceClient configSourceClient;
    private final ConfigSourceSet configSourceSet;
    private final TimingValues timingValues;
    private final JRTConfigRequester requester;
    private final MemoryCache memoryCache;
    private GenericConfigSubscriber subscriber;
    private GenericConfigHandle handle;

    UpstreamConfigSubscriber(RawConfig config, ConfigSourceClient configSourceClient, ConfigSourceSet configSourceSet, TimingValues timingValues, JRTConfigRequester requester, MemoryCache memoryCache) {
        this.config = config;
        this.configSourceClient = configSourceClient;
        this.configSourceSet = configSourceSet;
        this.timingValues = timingValues;
        this.requester = requester;
        this.memoryCache = memoryCache;
    }

    void subscribe() {
        this.subscriber = new GenericConfigSubscriber(Map.of(this.configSourceSet, this.requester));
        ConfigKey key = this.config.getKey();
        this.handle = this.subscriber.subscribe(new ConfigKey(key.getName(), key.getConfigId(), key.getNamespace()), this.config.getDefContent(), (ConfigSource)this.configSourceSet, this.timingValues);
    }

    @Override
    public void run() {
        do {
            if (!this.subscriber.nextGeneration()) continue;
            try {
                this.updateWithNewConfig(this.handle);
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, "Got exception: " + Exceptions.toMessageString((Throwable)e));
            }
            catch (Throwable e) {
                Process.logAndDie((String)("Got error, exiting: " + Exceptions.toMessageString((Throwable)e)));
            }
        } while (!this.subscriber.isClosed());
    }

    private void updateWithNewConfig(GenericConfigHandle handle) {
        RawConfig newConfig = handle.getRawConfig();
        log.log((Level)LogLevel.DEBUG, () -> "config to be returned for '" + newConfig.getKey() + "', generation=" + newConfig.getGeneration() + ", payload=" + newConfig.getPayload());
        this.memoryCache.update(newConfig);
        this.configSourceClient.updateSubscribers(newConfig);
    }

    @Override
    public void cancel() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }
}

