/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.proxy.ClientUpdater;
import com.yahoo.vespa.config.proxy.ConfigSourceClient;
import com.yahoo.vespa.config.proxy.DelayedResponse;
import com.yahoo.vespa.config.proxy.DelayedResponses;
import com.yahoo.vespa.config.proxy.MemoryCache;
import com.yahoo.vespa.config.proxy.ProxyServer;
import com.yahoo.vespa.config.proxy.Subscriber;
import com.yahoo.vespa.config.proxy.UpstreamConfigSubscriber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

class RpcConfigSourceClient
implements ConfigSourceClient {
    private static final Logger log = Logger.getLogger(RpcConfigSourceClient.class.getName());
    private final Supervisor supervisor = new Supervisor(new Transport());
    private final ConfigSourceSet configSourceSet;
    private final HashMap<ConfigCacheKey, Subscriber> activeSubscribers = new HashMap();
    private final Object activeSubscribersLock = new Object();
    private final MemoryCache memoryCache;
    private final ClientUpdater clientUpdater;
    private final DelayedResponses delayedResponses;
    private final TimingValues timingValues;
    private ExecutorService exec;
    private Map<ConfigSourceSet, JRTConfigRequester> requesterPool;

    RpcConfigSourceClient(ConfigSourceSet configSourceSet, ClientUpdater clientUpdater, MemoryCache memoryCache, TimingValues timingValues, DelayedResponses delayedResponses) {
        this.configSourceSet = configSourceSet;
        this.clientUpdater = clientUpdater;
        this.memoryCache = memoryCache;
        this.delayedResponses = delayedResponses;
        this.timingValues = timingValues;
        this.checkConfigSources();
        this.exec = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory("subscriber-"));
        this.requesterPool = this.createRequesterPool(configSourceSet, timingValues);
    }

    private Map<ConfigSourceSet, JRTConfigRequester> createRequesterPool(ConfigSourceSet ccs, TimingValues timingValues) {
        HashMap<ConfigSourceSet, JRTConfigRequester> ret = new HashMap<ConfigSourceSet, JRTConfigRequester>();
        if (ccs.getSources().isEmpty()) {
            return ret;
        }
        ret.put(ccs, JRTConfigRequester.get((ConnectionPool)new JRTConnectionPool(ccs), (TimingValues)timingValues));
        return ret;
    }

    private void checkConfigSources() {
        if (this.configSourceSet == null || this.configSourceSet.getSources() == null || this.configSourceSet.getSources().size() == 0) {
            log.log(LogLevel.WARNING, "No config sources defined, could not check connection");
        } else {
            Request req = new Request("ping");
            for (String configSource : this.configSourceSet.getSources()) {
                Spec spec = new Spec(configSource);
                Target target = this.supervisor.connect(spec);
                target.invokeSync(req, 30.0);
                if (target.isValid()) {
                    log.log((Level)LogLevel.DEBUG, "Created connection to config source at " + spec.toString());
                    return;
                }
                log.log(LogLevel.INFO, "Could not connect to config source at " + spec.toString());
                target.close();
            }
            String extra = "";
            log.log(LogLevel.INFO, "Could not connect to any config source in set " + this.configSourceSet.toString() + ", please make sure config server(s) are running. " + extra);
        }
    }

    @Override
    public RawConfig getConfig(RawConfig input, JRTServerConfigRequest request) {
        DelayedResponse delayedResponse = new DelayedResponse(request);
        this.delayedResponses.add(delayedResponse);
        ConfigCacheKey configCacheKey = new ConfigCacheKey(input.getKey(), input.getDefMd5());
        RawConfig cachedConfig = this.memoryCache.get(configCacheKey);
        boolean needToGetConfig = true;
        RawConfig ret = null;
        if (cachedConfig != null) {
            log.log((Level)LogLevel.DEBUG, "Found config " + configCacheKey + " in cache, generation=" + cachedConfig.getGeneration() + ",configmd5=" + cachedConfig.getConfigMd5());
            if (log.isLoggable((Level)LogLevel.SPAM)) {
                log.log((Level)LogLevel.SPAM, "input config=" + input + ",cached config=" + cachedConfig);
            }
            if (ProxyServer.configOrGenerationHasChanged(cachedConfig, request)) {
                log.log((Level)LogLevel.SPAM, "Cached config is not equal to requested, will return it");
                if (this.delayedResponses.remove(delayedResponse)) {
                    ret = cachedConfig;
                }
            }
            if (!cachedConfig.isError()) {
                needToGetConfig = false;
            }
        }
        if (needToGetConfig) {
            this.subscribeToConfig(input, configCacheKey);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribeToConfig(RawConfig input, ConfigCacheKey configCacheKey) {
        Object object = this.activeSubscribersLock;
        synchronized (object) {
            if (this.activeSubscribers.containsKey(configCacheKey)) {
                log.log((Level)LogLevel.DEBUG, "Already a subscriber running for: " + configCacheKey);
            } else {
                log.log((Level)LogLevel.DEBUG, "Could not find good config in cache, creating subscriber for: " + configCacheKey);
                UpstreamConfigSubscriber subscriber = new UpstreamConfigSubscriber(input, this.clientUpdater, (ConfigSource)this.configSourceSet, this.timingValues, this.requesterPool, this.memoryCache);
                try {
                    subscriber.subscribe();
                    this.activeSubscribers.put(configCacheKey, subscriber);
                    this.exec.execute(subscriber);
                }
                catch (ConfigurationRuntimeException e) {
                    log.log(LogLevel.INFO, "Subscribe for '" + configCacheKey + "' failed, closing subscriber");
                    subscriber.cancel();
                }
            }
        }
    }

    @Override
    public void cancel() {
        this.shutdownSourceConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownSourceConnections() {
        Iterator<JRTConfigRequester> iterator = this.activeSubscribersLock;
        synchronized (iterator) {
            for (Subscriber subscriber : this.activeSubscribers.values()) {
                subscriber.cancel();
            }
            this.activeSubscribers.clear();
        }
        this.exec.shutdown();
        for (JRTConfigRequester requester : this.requesterPool.values()) {
            requester.close();
        }
    }

    @Override
    public String getActiveSourceConnection() {
        if (this.requesterPool.get(this.configSourceSet) != null) {
            return this.requesterPool.get(this.configSourceSet).getConnectionPool().getCurrent().getAddress();
        }
        return "";
    }

    @Override
    public List<String> getSourceConnections() {
        ArrayList<String> ret = new ArrayList<String>();
        JRTConfigRequester jrtConfigRequester = this.requesterPool.get(this.configSourceSet);
        if (jrtConfigRequester != null) {
            ret.addAll(this.configSourceSet.getSources());
        }
        return ret;
    }
}

