/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.log.LogLevel;
import com.yahoo.protect.Process;
import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.proxy.DelayedResponse;
import com.yahoo.vespa.config.proxy.DelayedResponses;
import com.yahoo.vespa.config.proxy.MemoryCache;
import com.yahoo.vespa.config.proxy.RpcServer;
import com.yahoo.yolean.Exceptions;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DelayedResponseHandler
implements Runnable {
    private static final Logger log = Logger.getLogger(DelayedResponseHandler.class.getName());
    private final DelayedResponses delayedResponses;
    private final MemoryCache memoryCache;
    private final RpcServer rpcServer;

    DelayedResponseHandler(DelayedResponses delayedResponses, MemoryCache memoryCache, RpcServer rpcServer) {
        this.delayedResponses = delayedResponses;
        this.memoryCache = memoryCache;
        this.rpcServer = rpcServer;
    }

    @Override
    public void run() {
        this.checkDelayedResponses();
    }

    void checkDelayedResponses() {
        try {
            DelayedResponse response;
            long start = System.currentTimeMillis();
            if (log.isLoggable((Level)LogLevel.SPAM)) {
                log.log((Level)LogLevel.SPAM, "Running DelayedResponseHandler. There are " + this.delayedResponses.size() + " delayed responses. First one is " + this.delayedResponses.responses().peek());
            }
            int i = 0;
            while ((response = (DelayedResponse)this.delayedResponses.responses().poll()) != null) {
                JRTServerConfigRequest request;
                ConfigCacheKey cacheKey;
                RawConfig config;
                if (log.isLoggable((Level)LogLevel.DEBUG)) {
                    log.log((Level)LogLevel.DEBUG, "Returning with response that has return time " + new Date(response.getReturnTime()));
                }
                if ((config = this.memoryCache.get(cacheKey = new ConfigCacheKey((request = response.getRequest()).getConfigKey(), request.getConfigKey().getMd5()))) != null) {
                    this.rpcServer.returnOkResponse(request, config);
                    ++i;
                    continue;
                }
                log.log(LogLevel.WARNING, "No config found for " + request.getConfigKey() + " within timeout, will retry");
            }
            if (log.isLoggable((Level)LogLevel.SPAM)) {
                log.log((Level)LogLevel.SPAM, "Finished running DelayedResponseHandler. " + i + " delayed responses sent in " + (System.currentTimeMillis() - start) + " ms");
            }
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Got exception in DelayedResponseHandler: " + Exceptions.toMessageString((Throwable)e));
        }
        catch (Throwable e) {
            Process.logAndDie((String)("Got error in DelayedResponseHandler, exiting: " + Exceptions.toMessageString((Throwable)e)));
        }
    }
}

