/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import ai.vespa.validation.Validation;
import java.util.List;
import java.util.Objects;

public class ZoneEndpoint {
    public static final int generation = 0;
    public static final ZoneEndpoint defaultEndpoint = new ZoneEndpoint(true, false, List.of());
    public static final ZoneEndpoint privateEndpoint = new ZoneEndpoint(false, false, List.of());
    private final boolean isPublicEndpoint;
    private final boolean isPrivateEndpoint;
    private final List<AllowedUrn> allowedUrns;

    public ZoneEndpoint(boolean isPublicEndpoint, boolean isPrivateEndpoint, List<AllowedUrn> allowedUrns) {
        this.isPublicEndpoint = isPublicEndpoint;
        this.isPrivateEndpoint = isPrivateEndpoint;
        this.allowedUrns = List.copyOf(allowedUrns);
    }

    public boolean isPublicEndpoint() {
        return this.isPublicEndpoint;
    }

    public boolean isPrivateEndpoint() {
        return this.isPrivateEndpoint;
    }

    public List<AllowedUrn> allowedUrns() {
        return this.allowedUrns;
    }

    public List<String> allowedUrnsWith(AccessType type) {
        return this.allowedUrns.stream().filter(urn -> urn.type == type).map(AllowedUrn::urn).toList();
    }

    public boolean isDefault() {
        return this.equals(defaultEndpoint);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoneEndpoint that = (ZoneEndpoint)o;
        return this.isPublicEndpoint == that.isPublicEndpoint && this.isPrivateEndpoint == that.isPrivateEndpoint && this.allowedUrns.equals(that.allowedUrns);
    }

    public int hashCode() {
        return Objects.hash(this.isPublicEndpoint, this.isPrivateEndpoint, this.allowedUrns);
    }

    public String toString() {
        return "ZoneEndpoint{isPublicEndpoint=" + this.isPublicEndpoint + ", isPrivateEndpoint=" + this.isPrivateEndpoint + ", allowedUrns=" + this.allowedUrns + "}";
    }

    public static enum AccessType {
        awsPrivateLink,
        gcpServiceConnect;

    }

    public static class AllowedUrn {
        private final AccessType type;
        private final String urn;

        public AllowedUrn(AccessType type, String urn) {
            this.type = Objects.requireNonNull(type);
            this.urn = Validation.requireNonBlank((String)urn, (String)"URN");
        }

        public AccessType type() {
            return this.type;
        }

        public String urn() {
            return this.urn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedUrn that = (AllowedUrn)o;
            return this.type == that.type && this.urn.equals(that.urn);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.urn});
        }

        public String toString() {
            return "'" + this.urn + "' through '" + (switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case AccessType.awsPrivateLink -> "aws-private-link";
                case AccessType.gcpServiceConnect -> "gcp-service-connect";
            }) + "'";
        }
    }
}

