/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import ai.vespa.validation.Validation;
import java.time.Duration;
import java.util.Objects;

public class ClusterInfo {
    private static final ClusterInfo empty = new Builder().build();
    private final Duration bcpDeadline;
    private final Duration hostTTL;

    private ClusterInfo(Builder builder) {
        this.bcpDeadline = builder.bcpDeadline;
        this.hostTTL = builder.hostTTL;
        Validation.requireAtLeast((Comparable)this.hostTTL, (String)"host TTL", (Comparable)Duration.ZERO);
    }

    public Duration bcpDeadline() {
        return this.bcpDeadline;
    }

    public Duration hostTTL() {
        return this.hostTTL;
    }

    public static ClusterInfo empty() {
        return empty;
    }

    public boolean isEmpty() {
        return this.equals(empty);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo other = (ClusterInfo)o;
        if (!other.bcpDeadline.equals(this.bcpDeadline)) {
            return false;
        }
        return other.hostTTL.equals(this.hostTTL);
    }

    public int hashCode() {
        return Objects.hash(this.bcpDeadline, this.hostTTL);
    }

    public String toString() {
        return "cluster info: [bcp deadline: " + this.bcpDeadline + ", host TTL: " + this.hostTTL + "]";
    }

    public static class Builder {
        private Duration bcpDeadline = Duration.ZERO;
        private Duration hostTTL = Duration.ZERO;

        public Builder bcpDeadline(Duration duration) {
            this.bcpDeadline = Objects.requireNonNull(duration);
            return this;
        }

        public Builder hostTTL(Duration duration) {
            this.hostTTL = Objects.requireNonNull(duration);
            return this;
        }

        public ClusterInfo build() {
            return new ClusterInfo(this);
        }
    }
}

