/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterInfo;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.IntRange;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.NodeType;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public final class Capacity {
    private final ClusterResources min;
    private final ClusterResources max;
    private final IntRange groupSize;
    private final boolean required;
    private final boolean canFail;
    private final NodeType type;
    private final Optional<CloudAccount> cloudAccount;
    private final ClusterInfo clusterInfo;

    private Capacity(ClusterResources min, ClusterResources max, IntRange groupSize, boolean required, boolean canFail, NodeType type, Optional<CloudAccount> cloudAccount, ClusterInfo clusterInfo) {
        Capacity.validate(min);
        Capacity.validate(max);
        if (max.smallerThan(min)) {
            throw new IllegalArgumentException("The max capacity must be larger than the min capacity, but got min " + min + " and max " + max);
        }
        if (cloudAccount.isEmpty() && !clusterInfo.hostTTL().isZero()) {
            throw new IllegalArgumentException("Cannot set hostTTL without a custom cloud account");
        }
        this.min = min;
        this.max = max;
        this.groupSize = groupSize;
        this.required = required;
        this.canFail = canFail;
        this.type = type;
        this.cloudAccount = Objects.requireNonNull(cloudAccount);
        this.clusterInfo = clusterInfo;
    }

    private static void validate(ClusterResources resources) {
        if (resources.nodes() == 0 && resources.groups() == 0) {
            return;
        }
        if (resources.nodes() % resources.groups() != 0) {
            throw new IllegalArgumentException("The number of nodes (" + resources.nodes() + ") must be divisible by the number of groups (" + resources.groups() + ")");
        }
    }

    public ClusterResources minResources() {
        return this.min;
    }

    public ClusterResources maxResources() {
        return this.max;
    }

    public IntRange groupSize() {
        return this.groupSize;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean canFail() {
        return this.canFail;
    }

    public NodeType type() {
        return this.type;
    }

    public Optional<CloudAccount> cloudAccount() {
        return this.cloudAccount;
    }

    public ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    public Capacity withLimits(ClusterResources min, ClusterResources max) {
        return this.withLimits(min, max, IntRange.empty());
    }

    public Capacity withLimits(ClusterResources min, ClusterResources max, IntRange groupSize) {
        return new Capacity(min, max, groupSize, this.required, this.canFail, this.type, this.cloudAccount, this.clusterInfo);
    }

    public String toString() {
        return (this.required ? "required " : "") + (this.min.equals(this.max) ? this.min : "between " + this.min + " and " + this.max);
    }

    public static Capacity from(ClusterResources resources) {
        return Capacity.from(resources, resources);
    }

    public static Capacity from(ClusterResources min, ClusterResources max) {
        return Capacity.from(min, max, IntRange.empty(), false, true, Optional.empty(), ClusterInfo.empty());
    }

    public static Capacity from(ClusterResources resources, boolean required, boolean canFail) {
        return Capacity.from(resources, required, canFail, Duration.ZERO);
    }

    public static Capacity from(ClusterResources resources, boolean required, boolean canFail, Duration hostTTL) {
        return Capacity.from(resources, required, canFail, NodeType.tenant, hostTTL);
    }

    public static Capacity from(ClusterResources min, ClusterResources max, IntRange groupSize, boolean required, boolean canFail, Optional<CloudAccount> cloudAccount, ClusterInfo clusterInfo) {
        return new Capacity(min, max, groupSize, required, canFail, NodeType.tenant, cloudAccount, clusterInfo);
    }

    public static Capacity from(ClusterResources min, ClusterResources max, boolean required, boolean canFail) {
        return new Capacity(min, max, IntRange.empty(), required, canFail, NodeType.tenant, Optional.empty(), ClusterInfo.empty());
    }

    public static Capacity from(ClusterResources min, ClusterResources max, boolean required, boolean canFail, Optional<CloudAccount> cloudAccount) {
        return new Capacity(min, max, IntRange.empty(), required, canFail, NodeType.tenant, cloudAccount, ClusterInfo.empty());
    }

    public static Capacity from(ClusterResources min, ClusterResources max, IntRange groupSize, boolean required, boolean canFail, Optional<CloudAccount> cloudAccount) {
        return new Capacity(min, max, groupSize, required, canFail, NodeType.tenant, cloudAccount, ClusterInfo.empty());
    }

    public static Capacity fromRequiredNodeType(NodeType type) {
        return Capacity.from(new ClusterResources(0, 1, NodeResources.unspecified()), true, false, type, Duration.ZERO);
    }

    private static Capacity from(ClusterResources resources, boolean required, boolean canFail, NodeType type, Duration hostTTL) {
        return new Capacity(resources, resources, IntRange.empty(), required, canFail, type, Optional.empty(), new ClusterInfo.Builder().hostTTL(hostTTL).build());
    }
}

