/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.EmbedExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmbedExpressionValidator
implements Validator {
    private static final Logger log = Logger.getLogger(EmbedExpressionValidator.class.getName());

    @Override
    public void validate(Validation.Context context) {
        record SchemaAndField(String schemaName, String fieldName) {
        }
        HashMap<SchemaAndField, String> fieldToEmbedderId = new HashMap<SchemaAndField, String>();
        context.model().getContentClusters().forEach((__, contentCluster) -> {
            if (!contentCluster.getSearch().hasSearchCluster()) {
                return;
            }
            contentCluster.getSearch().getSearchCluster().schemas().forEach((___, schema) -> schema.fullSchema().allFields().forEach(field -> {
                if (field.isImportedField() || field.getIndexingScript().isEmpty()) {
                    return;
                }
                ExpressionVisitor visitor = new ExpressionVisitor((ImmutableSDField)field, (SchemaInfo)schema, fieldToEmbedderId){
                    final /* synthetic */ ImmutableSDField val$field;
                    final /* synthetic */ SchemaInfo val$schema;
                    final /* synthetic */ HashMap val$fieldToEmbedderId;
                    {
                        this.val$field = immutableSDField;
                        this.val$schema = schemaInfo;
                        this.val$fieldToEmbedderId = hashMap;
                    }

                    protected void doVisit(Expression e) {
                        if (e instanceof EmbedExpression) {
                            EmbedExpression ee = (EmbedExpression)e;
                            ee.requestedEmbedderId().ifPresent(id -> {
                                String fieldName = this.val$field.getName();
                                String schemaName = this.val$schema.fullSchema().getName();
                                log.log(Level.FINE, () -> "Found embedder '%s' for field '%s' in schema '%s'".formatted(id, fieldName, schemaName));
                                this.val$fieldToEmbedderId.put(new SchemaAndField(schemaName, fieldName), id);
                            });
                        }
                    }
                };
                visitor.visit((Expression)field.getIndexingScript());
            }));
        });
        HashSet allComponentIds = new HashSet();
        context.model().getContainerClusters().forEach((__, containerCluster) -> containerCluster.getAllComponents().forEach(component -> {
            String id = component.getComponentId().getName();
            log.log(Level.FINE, () -> "Found component id '%s'".formatted(id));
            allComponentIds.add(id);
        }));
        fieldToEmbedderId.forEach((field, requestedEmbedderId) -> {
            if (!allComponentIds.contains(requestedEmbedderId)) {
                context.illegal("The 'embed' expression for field '%s' in schema '%s' refers to an embedder with id '%s'. No component with that id is configured.".formatted(field.fieldName(), field.schemaName(), requestedEmbedderId));
            }
        });
    }
}

