/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema;

import com.yahoo.schema.Schema;
import com.yahoo.schema.document.FieldSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class FieldSets {
    private final Optional<Schema> owner;
    private final Map<String, FieldSet> userFieldSets;
    private final Map<String, FieldSet> builtInFieldSets;

    public FieldSets(Optional<Schema> owner) {
        this.owner = owner;
        this.userFieldSets = new LinkedHashMap<String, FieldSet>();
        this.builtInFieldSets = new LinkedHashMap<String, FieldSet>();
    }

    public void addUserFieldSetItem(String setName, String field) {
        if (this.userFieldSets.get(setName) == null) {
            this.userFieldSets.put(setName, new FieldSet(setName));
        }
        this.userFieldSets.get(setName).addFieldName(field);
    }

    public void addBuiltInFieldSetItem(String setName, String field) {
        this.builtInFieldSets.computeIfAbsent(setName, FieldSet::new).addFieldName(field);
    }

    public Map<String, FieldSet> builtInFieldSets() {
        if (this.owner.isEmpty() || this.owner.get().inherited().isEmpty()) {
            return Collections.unmodifiableMap(this.builtInFieldSets);
        }
        if (this.builtInFieldSets.isEmpty()) {
            return this.owner.get().inherited().get().fieldSets().builtInFieldSets();
        }
        LinkedHashMap<String, FieldSet> fieldSets = new LinkedHashMap<String, FieldSet>(this.owner.get().inherited().get().fieldSets().builtInFieldSets());
        fieldSets.putAll(this.builtInFieldSets);
        return Collections.unmodifiableMap(fieldSets);
    }

    public Map<String, FieldSet> userFieldSets() {
        if (this.owner.isEmpty() || this.owner.get().inherited().isEmpty()) {
            return Collections.unmodifiableMap(this.userFieldSets);
        }
        if (this.userFieldSets.isEmpty()) {
            return this.owner.get().inherited().get().fieldSets().userFieldSets();
        }
        LinkedHashMap<String, FieldSet> fieldSets = new LinkedHashMap<String, FieldSet>(this.owner.get().inherited().get().fieldSets().userFieldSets());
        fieldSets.putAll(this.userFieldSets);
        return Collections.unmodifiableMap(fieldSets);
    }
}

