/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model;

import com.yahoo.vespa.defaults.Defaults;
import java.util.Optional;

public class MallocImplResolver {
    public static Optional<String> pathToLibrary(String impl) {
        if (impl == null || impl.isEmpty()) {
            return Optional.empty();
        }
        return switch (Impl.valueOf(impl)) {
            default -> throw new IncompatibleClassChangeError();
            case Impl.mimalloc -> Optional.of(MallocImplResolver.resolveMimallocPath());
            case Impl.vespamalloc -> Optional.of(MallocImplResolver.resolveVespaMallocPath());
            case Impl.vespamallocd -> Optional.of(MallocImplResolver.resolveVespaMallocDebugPath());
            case Impl.vespamallocdst -> Optional.of(MallocImplResolver.resolveVespaMallocDstPath());
        };
    }

    private static String resolveMimallocPath() {
        return "/opt/vespa-deps/lib64/libmimalloc.so";
    }

    private static String resolveVespaMallocPath() {
        return Defaults.getDefaults().underVespaHome("lib64/vespa/malloc/libvespamalloc.so");
    }

    private static String resolveVespaMallocDebugPath() {
        return Defaults.getDefaults().underVespaHome("lib64/vespa/malloc/libvespamallocd.so");
    }

    private static String resolveVespaMallocDstPath() {
        return Defaults.getDefaults().underVespaHome("lib64/vespa/malloc/libvespamallocdst16.so");
    }

    public static enum Impl {
        mimalloc,
        vespamalloc,
        vespamallocd,
        vespamallocdst;

    }
}

