/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.container.logging.ConnectionLog;
import com.yahoo.container.logging.ConnectionLogConfig;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;

public class ConnectionLogComponent
extends SimpleComponent
implements ConnectionLogConfig.Producer {
    private final String logDirectoryName;
    private final String clusterName;
    private final boolean isHostedVespa;

    public ConnectionLogComponent(ContainerCluster<?> cluster, Class<? extends ConnectionLog> cls, String logDirectoryName) {
        this(cls, logDirectoryName, cluster.getName(), cluster.isHostedVespa());
    }

    public ConnectionLogComponent(Class<? extends ConnectionLog> cls, String logDirectoryName, String clusterName, boolean isHostedVespa) {
        super(cls.getName());
        this.logDirectoryName = logDirectoryName;
        this.clusterName = clusterName;
        this.isHostedVespa = isHostedVespa;
    }

    public void getConfig(ConnectionLogConfig.Builder builder) {
        builder.cluster(this.clusterName);
        builder.logDirectoryName(this.logDirectoryName);
        if (this.isHostedVespa) {
            builder.useClusterIdInFileName(false);
        }
        builder.queueSize(-1);
    }
}

