/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import ai.vespa.secret.config.SecretsConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.ArrayList;
import java.util.List;

public class CloudSecrets
extends SimpleComponent
implements SecretsConfig.Producer {
    static final String CLASS = "ai.vespa.secret.aws.SecretsImpl";
    private static final String BUNDLE = "jdisc-cloud-aws";
    private final List<SecretConfig> secrets = new ArrayList<SecretConfig>();

    public CloudSecrets() {
        super(new ComponentModel(BundleInstantiationSpecification.fromStrings((String)CLASS, (String)CLASS, (String)BUNDLE)));
    }

    public void getConfig(SecretsConfig.Builder builder) {
        this.secrets.forEach(secret -> builder.secret(secret.key(), new SecretsConfig.Secret.Builder().name(secret.name()).vault(secret.vault())));
    }

    public void addSecret(String key, String name, String vault) {
        this.secrets.add(new SecretConfig(key, name, vault));
    }

    public List<SecretConfig> configuredSecrets() {
        return List.copyOf(this.secrets);
    }

    public record SecretConfig(String key, String name, String vault) {
    }
}

