/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.document.SDField;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.List;
import java.util.logging.Level;

public class SearchDataTypeValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        List<SearchCluster> clusters = context.model().getSearchClusters();
        for (SearchCluster cluster : clusters) {
            for (SchemaInfo spec : cluster.schemas().values()) {
                SDDocumentType docType = spec.fullSchema().getDocument();
                if (docType == null || spec.getIndexMode() != SchemaInfo.IndexMode.INDEX) continue;
                this.validateDocument(context, cluster, spec.fullSchema(), docType);
            }
        }
    }

    private void validateDocument(Validation.Context context, SearchCluster cluster, Schema schema, SDDocumentType doc) {
        for (SDDocumentType child : doc.getTypes()) {
            this.validateDocument(context, cluster, schema, child);
        }
        for (Field field : doc.fieldSet()) {
            DataType fieldType = field.getDataType();
            this.disallowIndexingOfMaps(context, cluster, schema, field);
            this.disallowIndexingOfUnsupportedDataTypes(context, cluster, schema, field);
            if (this.isSupportedInSearchClusters(fieldType)) continue;
            context.illegal("Field type '" + fieldType.getName() + "' is illegal for search clusters (field '" + field.getName() + "' in schema '" + schema.getName() + "' for cluster '" + cluster.getClusterName() + "').");
        }
    }

    private boolean isSupportedInSearchClusters(DataType dataType) {
        if (dataType instanceof ArrayDataType || dataType instanceof WeightedSetDataType) {
            return this.isSupportedInSearchClusters(((CollectionDataType)dataType).getNestedType());
        }
        if (dataType instanceof StructDataType) {
            return true;
        }
        if (dataType instanceof MapDataType) {
            return true;
        }
        if (dataType instanceof TensorDataType) {
            return true;
        }
        if (dataType instanceof NewDocumentReferenceDataType) {
            return true;
        }
        return dataType.equals((Object)DataType.INT) || dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.STRING) || dataType.equals((Object)DataType.RAW) || dataType.equals((Object)DataType.LONG) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.URI) || dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.BOOL) || dataType.equals((Object)DataType.PREDICATE);
    }

    private void disallowIndexingOfMaps(Validation.Context context, SearchCluster cluster, Schema schema, Field field) {
        DataType fieldType = field.getDataType();
        if (fieldType instanceof MapDataType && ((SDField)field).doesIndexing()) {
            context.illegal("Field type '" + fieldType.getName() + "' cannot be indexed for search clusters (field '" + field.getName() + "' in definition '" + schema.getName() + "' for cluster '" + cluster.getClusterName() + "').");
        }
    }

    private void disallowIndexingOfUnsupportedDataTypes(Validation.Context context, SearchCluster cluster, Schema schema, Field field) {
        DataType fieldType;
        DataType nestedFieldType = fieldType = field.getDataType();
        if (fieldType instanceof CollectionDataType) {
            CollectionDataType collectionDataType = (CollectionDataType)fieldType;
            nestedFieldType = collectionDataType.getNestedType();
        }
        if (!nestedFieldType.equals((Object)DataType.STRING) && !nestedFieldType.equals((Object)DataType.URI) && !(fieldType instanceof TensorDataType) && ((SDField)field).doesIndexing()) {
            context.deployState().getDeployLogger().logApplicationPackage(Level.WARNING, "In cluster '" + cluster.getClusterName() + "', schema '" + schema.getName() + "', field '" + field.getName() + "': Field type '" + field.getDataType().getName() + "' cannot be indexed");
        }
    }
}

