/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configmodel.producers;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.documentmodel.OwnedTemporaryType;
import com.yahoo.documentmodel.TemporaryUnknownType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.schema.document.FieldSet;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.configmodel.producers.DataTypeRecognizer;
import com.yahoo.vespa.documentmodel.DocumentModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DocumentManager {
    private boolean useV8GeoPositions = false;

    public DocumentManager useV8GeoPositions(boolean useV8GeoPositions) {
        this.useV8GeoPositions = useV8GeoPositions;
        return this;
    }

    public DocumentmanagerConfig.Builder produce(DocumentModel model, DocumentmanagerConfig.Builder documentConfigBuilder) {
        return this.produceDocTypes(model, documentConfigBuilder);
    }

    public DocumentmanagerConfig.Builder produceDocTypes(DocumentModel model, DocumentmanagerConfig.Builder builder) {
        builder.usev8geopositions(this.useV8GeoPositions);
        HashMap<NewDocumentType.Name, NewDocumentType> produced = new HashMap<NewDocumentType.Name, NewDocumentType>();
        IdxMap indexMap = new IdxMap();
        for (NewDocumentType documentType : model.getDocumentManager().getTypes()) {
            this.docTypeInheritOrder(documentType, builder, produced, indexMap);
        }
        indexMap.verifyAllDone();
        return builder;
    }

    private void docTypeInheritOrder(NewDocumentType documentType, DocumentmanagerConfig.Builder builder, Map<NewDocumentType.Name, NewDocumentType> produced, IdxMap indexMap) {
        if (!produced.containsKey(documentType.getFullName())) {
            for (NewDocumentType inherited : documentType.getInherited()) {
                this.docTypeInheritOrder(inherited, builder, produced, indexMap);
            }
            this.docTypeBuild(documentType, builder, indexMap);
            produced.put(documentType.getFullName(), documentType);
        }
    }

    private static <T> List<T> sortedList(Collection<T> unsorted, Comparator<T> cmp) {
        ArrayList<T> list = new ArrayList<T>(unsorted);
        list.sort(cmp);
        return list;
    }

    private void docTypeBuild(NewDocumentType documentType, DocumentmanagerConfig.Builder builder, IdxMap indexMap) {
        DocumentmanagerConfig.Doctype.Builder db = new DocumentmanagerConfig.Doctype.Builder();
        db.idx(indexMap.idxOf(documentType)).name(documentType.getName()).contentstruct(indexMap.idxOf(documentType.getContentStruct()));
        this.docTypeBuildFieldSets(documentType.getFieldSets(), db);
        this.docTypeBuildImportedFields(documentType.getImportedFieldNames(), db);
        for (NewDocumentType inherited : documentType.getInherited()) {
            db.inherits(b -> b.idx(indexMap.idxOf(inherited)));
        }
        this.docTypeBuildAnyType(documentType.getContentStruct(), db, indexMap);
        for (DataType dt : DocumentManager.sortedList(documentType.getAllTypes().getTypes(), (a, b) -> a.getName().compareTo(b.getName()))) {
            this.docTypeBuildAnyType(dt, db, indexMap);
        }
        for (AnnotationType ann : DocumentManager.sortedList(documentType.getAnnotations(), (a, b) -> a.getName().compareTo(b.getName()))) {
            this.docTypeBuildAnnotationType(ann, db, indexMap);
        }
        builder.doctype(db);
        indexMap.setDone(documentType);
    }

    private void docTypeBuildFieldSets(Set<FieldSet> fieldSets, DocumentmanagerConfig.Doctype.Builder db) {
        for (FieldSet fs : fieldSets) {
            this.docTypeBuildOneFieldSet(fs, db);
        }
    }

    private void docTypeBuildOneFieldSet(FieldSet fs, DocumentmanagerConfig.Doctype.Builder db) {
        db.fieldsets(fs.getName(), new DocumentmanagerConfig.Doctype.Fieldsets.Builder().fields(fs.getFieldNames()));
    }

    private void docTypeBuildAnnotationType(AnnotationType annotation, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        if (indexMap.isDone(annotation)) {
            return;
        }
        indexMap.setDone(annotation);
        DocumentmanagerConfig.Doctype.Annotationtype.Builder annBuilder = new DocumentmanagerConfig.Doctype.Annotationtype.Builder();
        annBuilder.idx(indexMap.idxOf(annotation)).name(annotation.getName()).internalid(annotation.getId());
        DataType nested = annotation.getDataType();
        if (nested != null) {
            annBuilder.datatype(indexMap.idxOf(nested));
            this.docTypeBuildAnyType(nested, builder, indexMap);
        }
        for (AnnotationType inherited : annotation.getInheritedTypes()) {
            annBuilder.inherits(inhBuilder -> inhBuilder.idx(indexMap.idxOf(inherited)));
        }
        builder.annotationtype(annBuilder);
    }

    private void docTypeBuildAnyType(DataType type, DocumentmanagerConfig.Doctype.Builder documentBuilder, IdxMap indexMap) {
        if (indexMap.isDone(type)) {
            return;
        }
        if (type instanceof NewDocumentType) {
            return;
        }
        if (type instanceof DocumentType && type.getId() == 8) {
            return;
        }
        indexMap.setDone(type);
        if (type instanceof TemporaryUnknownType) {
            throw new IllegalArgumentException("Can not create config for temporary data type: " + type.getName());
        }
        if (type instanceof OwnedTemporaryType) {
            throw new IllegalArgumentException("Can not create config for temporary data type: " + type.getName());
        }
        if (type instanceof StructDataType) {
            this.docTypeBuildOneType((StructDataType)type, documentBuilder, indexMap);
        } else if (type instanceof ArrayDataType) {
            this.docTypeBuildOneType((ArrayDataType)type, documentBuilder, indexMap);
        } else if (type instanceof WeightedSetDataType) {
            this.docTypeBuildOneType((WeightedSetDataType)type, documentBuilder, indexMap);
        } else if (type instanceof MapDataType) {
            this.docTypeBuildOneType((MapDataType)type, documentBuilder, indexMap);
        } else if (type instanceof AnnotationReferenceDataType) {
            this.docTypeBuildOneType((AnnotationReferenceDataType)type, documentBuilder, indexMap);
        } else if (type instanceof TensorDataType) {
            this.docTypeBuildOneType((TensorDataType)type, documentBuilder, indexMap);
        } else if (type instanceof NewDocumentReferenceDataType) {
            NewDocumentReferenceDataType refType = (NewDocumentReferenceDataType)type;
            if (refType.isTemporary()) {
                throw new IllegalArgumentException("Still temporary: " + String.valueOf((Object)refType));
            }
            this.docTypeBuildOneType(refType, documentBuilder, indexMap);
        } else if (type instanceof PrimitiveDataType) {
            this.docTypeBuildOneType((PrimitiveDataType)type, documentBuilder, indexMap);
        } else {
            if (type instanceof DocumentType) {
                throw new IllegalArgumentException("Can not create config for unadorned document type: " + type.getName() + " id " + type.getId());
            }
            throw new IllegalArgumentException("Can not create config for data type " + String.valueOf(type) + " of class " + String.valueOf(type.getClass()));
        }
    }

    private void docTypeBuildImportedFields(Collection<String> fieldNames, DocumentmanagerConfig.Doctype.Builder builder) {
        for (String fieldName : fieldNames) {
            builder.importedfield(ib -> ib.name(fieldName));
        }
    }

    private void docTypeBuildOneType(StructDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        DocumentmanagerConfig.Doctype.Structtype.Builder structBuilder = new DocumentmanagerConfig.Doctype.Structtype.Builder();
        structBuilder.idx(indexMap.idxOf(type)).name(type.getName());
        for (DataType inherited : type.getInheritedTypes()) {
            structBuilder.inherits(inheritBuilder -> inheritBuilder.type(indexMap.idxOf(inherited)));
            this.docTypeBuildAnyType(inherited, builder, indexMap);
        }
        for (Field field : type.getFieldsThisTypeOnly()) {
            DataType fieldType = field.getDataType();
            structBuilder.field(fieldBuilder -> fieldBuilder.name(field.getName()).internalid(field.getId()).type(indexMap.idxOf(fieldType)));
            this.docTypeBuildAnyType(fieldType, builder, indexMap);
        }
        builder.structtype(structBuilder);
    }

    private void docTypeBuildOneType(PrimitiveDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        builder.primitivetype(primBuilder -> primBuilder.idx(indexMap.idxOf(type)).name(type.getName()));
    }

    private void docTypeBuildOneType(TensorDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        TensorType tt = type.getTensorType();
        String detailed = tt != null ? tt.toString() : "tensor";
        builder.tensortype(tensorBuilder -> tensorBuilder.idx(indexMap.idxOf(type)).detailedtype(detailed));
    }

    private void docTypeBuildOneType(ArrayDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        DataType nested = type.getNestedType();
        builder.arraytype(arrayBuilder -> arrayBuilder.idx(indexMap.idxOf(type)).elementtype(indexMap.idxOf(nested)));
        this.docTypeBuildAnyType(nested, builder, indexMap);
    }

    private void docTypeBuildOneType(WeightedSetDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        DataType nested = type.getNestedType();
        builder.wsettype(wsetBuilder -> wsetBuilder.idx(indexMap.idxOf(type)).elementtype(indexMap.idxOf(nested)).createifnonexistent(type.createIfNonExistent()).removeifzero(type.removeIfZero()));
        this.docTypeBuildAnyType(nested, builder, indexMap);
    }

    private void docTypeBuildOneType(MapDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        DataType keytype = type.getKeyType();
        DataType valtype = type.getValueType();
        builder.maptype(mapBuilder -> mapBuilder.idx(indexMap.idxOf(type)).keytype(indexMap.idxOf(keytype)).valuetype(indexMap.idxOf(valtype)));
        this.docTypeBuildAnyType(keytype, builder, indexMap);
        this.docTypeBuildAnyType(valtype, builder, indexMap);
    }

    private void docTypeBuildOneType(AnnotationReferenceDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        builder.annotationref(arefBuilder -> arefBuilder.idx(indexMap.idxOf(type)).annotationtype(indexMap.idxOf(type.getAnnotationType())));
    }

    private void docTypeBuildOneType(NewDocumentReferenceDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        builder.documentref(docrefBuilder -> docrefBuilder.idx(indexMap.idxOf((Object)type)).targettype(indexMap.idxOf(type.getTargetType())));
    }

    private static class IdxMap {
        private final Map<Integer, Boolean> doneMap = new HashMap<Integer, Boolean>();
        private final Map<String, Integer> map = new HashMap<String, Integer>();
        private final DataTypeRecognizer recognizer = new DataTypeRecognizer();

        private IdxMap() {
        }

        private void add(String name) {
            int nextIdx = 10000 + this.map.size();
            this.map.computeIfAbsent(name, k -> nextIdx);
        }

        int idxOf(Object someType) {
            DocumentType dt;
            if (someType instanceof DocumentType && (dt = (DocumentType)someType).getId() == 8) {
                return this.idxOf(VespaDocumentType.INSTANCE);
            }
            String name = this.recognizer.nameOf(someType);
            this.add(name);
            return this.map.get(name);
        }

        private boolean isDoneIdx(int idx) {
            return this.doneMap.computeIfAbsent(idx, k -> false);
        }

        boolean isDone(Object someType) {
            return this.isDoneIdx(this.idxOf(someType));
        }

        void setDone(Object someType) {
            assert (!this.isDone(someType));
            this.doneMap.put(this.idxOf(someType), true);
        }

        void verifyAllDone() {
            for (Map.Entry<String, Integer> entry : this.map.entrySet()) {
                String needed = entry.getKey();
                int idxOfNeed = entry.getValue();
                if (this.isDoneIdx(idxOfNeed)) continue;
                throw new IllegalArgumentException("Could not generate config for all needed types, missing: " + needed);
            }
        }
    }
}

