/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.schema.Index;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.derived.Index;
import com.yahoo.schema.document.FieldSet;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.config.search.IndexschemaConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class IndexSchema
extends Derived {
    private final List<IndexField> fields = new ArrayList<IndexField>();
    private final Map<String, FieldCollection> collections = new LinkedHashMap<String, FieldCollection>();
    private final Map<String, FieldSet> fieldSets = new LinkedHashMap<String, FieldSet>();

    public IndexSchema(Schema schema) {
        this.fieldSets.putAll(schema.fieldSets().userFieldSets());
        this.derive(schema);
    }

    public boolean containsField(String fieldName) {
        return this.fields.stream().anyMatch(field -> field.getName().equals(fieldName));
    }

    @Override
    protected void derive(Schema schema) {
        super.derive(schema);
    }

    private boolean isTensorField(ImmutableSDField field) {
        return field.getDataType() instanceof TensorDataType;
    }

    private void deriveIndexFields(ImmutableSDField field, Schema schema) {
        if (!field.doesIndexing() && !field.isIndexStructureField() || this.isTensorField(field)) {
            return;
        }
        List<Field> lst = IndexSchema.flattenField(field.asField());
        if (lst.isEmpty()) {
            return;
        }
        String fieldName = field.getName();
        for (Field flatField : lst) {
            this.deriveIndexFields(flatField, schema);
        }
        if (lst.size() > 1) {
            FieldSet fieldSet = new FieldSet(fieldName);
            for (Field flatField : lst) {
                fieldSet.addFieldName(flatField.getName());
            }
            this.fieldSets.put(fieldName, fieldSet);
        }
    }

    private void deriveIndexFields(Field field, Schema schema) {
        IndexField toAdd = new IndexField(field.getName(), com.yahoo.schema.derived.Index.convertType(field.getDataType()), field.getDataType());
        Index definedIndex = schema.getIndex(field.getName());
        if (definedIndex != null) {
            toAdd.setIndexSettings(definedIndex);
        }
        this.fields.add(toAdd);
        this.addFieldToCollection(field.getName(), field.getName());
    }

    private FieldCollection getCollection(String collectionName) {
        FieldCollection retval = this.collections.get(collectionName);
        if (retval == null) {
            this.collections.put(collectionName, new FieldCollection(collectionName));
            return this.collections.get(collectionName);
        }
        return retval;
    }

    private void addFieldToCollection(String fieldName, String collectionName) {
        FieldCollection collection = this.getCollection(collectionName);
        collection.fields.add(fieldName);
    }

    @Override
    protected void derive(ImmutableSDField field, Schema schema) {
        if (field.usesStructOrMap()) {
            return;
        }
        this.deriveIndexFields(field, schema);
    }

    @Override
    protected String getDerivedName() {
        return "indexschema";
    }

    private static IndexschemaConfig.Indexfield.Builder createIndexFieldConfig(IndexField f) {
        IndexschemaConfig.Indexfield.Builder ifB = new IndexschemaConfig.Indexfield.Builder().name(f.getName()).datatype(IndexschemaConfig.Indexfield.Datatype.Enum.valueOf((String)f.getType())).prefix(f.hasPrefix()).phrases(false).positions(true).interleavedfeatures(f.useInterleavedFeatures());
        if (!f.getCollectionType().equals("SINGLE")) {
            ifB.collectiontype(IndexschemaConfig.Indexfield.Collectiontype.Enum.valueOf((String)f.getCollectionType()));
        }
        return ifB;
    }

    private static IndexschemaConfig.Fieldset.Builder createFieldSetConfig(FieldSet fieldSet) {
        IndexschemaConfig.Fieldset.Builder fsB = new IndexschemaConfig.Fieldset.Builder().name(fieldSet.getName());
        for (String f : fieldSet.getFieldNames()) {
            fsB.field(new IndexschemaConfig.Fieldset.Field.Builder().name(f));
        }
        return fsB;
    }

    public void getConfig(IndexschemaConfig.Builder icB) {
        icB.indexfield(this.fields.stream().map(IndexSchema::createIndexFieldConfig).toList());
        icB.fieldset(this.fieldSets.values().stream().map(IndexSchema::createFieldSetConfig).toList());
    }

    public void export(String toDirectory) throws IOException {
        IndexschemaConfig.Builder builder = new IndexschemaConfig.Builder();
        this.getConfig(builder);
        this.export(toDirectory, (ConfigInstance)builder.build());
    }

    static List<Field> flattenField(Field field) {
        DataType fieldType = field.getDataType();
        if (fieldType.getPrimitiveType() != null) {
            return List.of(field);
        }
        if (fieldType instanceof ArrayDataType) {
            LinkedList<Field> ret = new LinkedList<Field>();
            Field innerField = new Field(field.getName(), ((ArrayDataType)fieldType).getNestedType());
            for (Field flatField : IndexSchema.flattenField(innerField)) {
                ret.add(new Field(flatField.getName(), (DataType)DataType.getArray((DataType)flatField.getDataType())));
            }
            return ret;
        }
        if (fieldType instanceof StructuredDataType) {
            LinkedList<Field> ret = new LinkedList<Field>();
            String fieldName = field.getName();
            for (Field childField : ((StructuredDataType)fieldType).getFields()) {
                for (Field flatField : IndexSchema.flattenField(childField)) {
                    ret.add(new Field(fieldName + "." + flatField.getName(), flatField));
                }
            }
            return ret;
        }
        throw new UnsupportedOperationException(fieldType.getName());
    }

    public List<IndexField> getFields() {
        return this.fields;
    }

    public static class IndexField {
        private final String name;
        private final Index.Type type;
        private final DataType sdFieldType;
        private boolean prefix = false;
        private boolean interleavedFeatures = false;

        public IndexField(String name, Index.Type type, DataType sdFieldType) {
            this.name = name;
            this.type = type;
            this.sdFieldType = sdFieldType;
        }

        public void setIndexSettings(Index index) {
            if (this.type.equals(Index.Type.TEXT)) {
                this.prefix = index.isPrefix();
                this.interleavedFeatures = index.useInterleavedFeatures();
            }
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type.equals(Index.Type.INT64) ? "INT64" : "STRING";
        }

        public String getCollectionType() {
            return this.sdFieldType == null ? "SINGLE" : (this.sdFieldType instanceof WeightedSetDataType ? "WEIGHTEDSET" : (this.sdFieldType instanceof ArrayDataType ? "ARRAY" : "SINGLE"));
        }

        public boolean hasPrefix() {
            return this.prefix;
        }

        public boolean useInterleavedFeatures() {
            return this.interleavedFeatures;
        }
    }

    private static class FieldCollection {
        private final String name;
        private final List<String> fields = new ArrayList<String>();

        FieldCollection(String name) {
            this.name = name;
        }
    }
}

