/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.Map;

public class GlobalDocumentChangeValidator
implements ChangeValidator {
    @Override
    public void validate(Validation.ChangeContext context) {
        for (Map.Entry<String, ContentCluster> currentEntry : context.previousModel().getContentClusters().entrySet()) {
            ContentCluster nextCluster = context.model().getContentClusters().get(currentEntry.getKey());
            if (nextCluster == null) continue;
            this.validateContentCluster(context, currentEntry.getValue(), nextCluster);
        }
    }

    private void validateContentCluster(Validation.ChangeContext context, ContentCluster currentCluster, ContentCluster nextCluster) {
        String clusterName = currentCluster.getName();
        currentCluster.getDocumentDefinitions().forEach((documentTypeName, currentDocumentType) -> {
            NewDocumentType nextDocumentType = nextCluster.getDocumentDefinitions().get(documentTypeName);
            if (nextDocumentType != null) {
                boolean currentIsGlobal = currentCluster.isGloballyDistributed((NewDocumentType)currentDocumentType);
                boolean nextIsGlobal = nextCluster.isGloballyDistributed(nextDocumentType);
                boolean hosted = context.deployState().isHosted();
                if (currentIsGlobal != nextIsGlobal) {
                    Object reason = "Document type %s in cluster %s changed global from %s to %s".formatted(documentTypeName, clusterName, currentIsGlobal, nextIsGlobal);
                    if (!context.deployState().validationOverrides().allows(ValidationId.globalDocumentChange, context.deployState().now())) {
                        if (!hosted) {
                            reason = (String)reason + "To handle this change, first stop services on all content nodes. Then, deploy with validation override. Finally, start services on all content nodes";
                        }
                        context.invalid(ValidationId.globalDocumentChange, (String)reason);
                    } else if (hosted) {
                        reason = (String)reason + "Content nodes will be restarted automatically";
                        context.require(new VespaRestartAction(ClusterSpec.Id.from((String)clusterName), (String)reason, nextCluster.getSearch().getSearchNodes().stream().map(AbstractService::getServiceInfo).toList()));
                    }
                }
            }
        });
    }
}

