/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import com.yahoo.vespa.model.container.http.ssl.HostedSslConnectorFactory;
import java.util.List;

public class CloudHttpConnectorValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        if (!context.deployState().isHostedTenantApplication(context.model().getAdmin().getApplicationType())) {
            return;
        }
        context.model().getContainerClusters().forEach((__, cluster) -> {
            Http http = cluster.getHttp();
            if (http == null) {
                return;
            }
            List<String> illegalConnectors = http.getHttpServer().stream().flatMap(s -> s.getConnectorFactories().stream().filter(c -> !CloudHttpConnectorValidator.isAllowedConnector(c))).map(cf -> "%s@%d".formatted(cf.getName(), cf.getListenPort())).toList();
            if (illegalConnectors.isEmpty()) {
                return;
            }
            context.illegal("Adding additional or modifying existing HTTPS connectors is not allowed for Vespa Cloud applications. Violating connectors: %s. See https://docs.vespa.ai/en/cloud/security/whitepaper.html, https://docs.vespa.ai/en/cloud/security/guide.html#data-plane.".formatted(illegalConnectors));
        });
    }

    private static boolean isAllowedConnector(ConnectorFactory cf) {
        return cf instanceof HostedSslConnectorFactory || cf.getClass().getSimpleName().endsWith("HealthCheckProxyConnector") || cf.getClass().getPackageName().startsWith("com.yahoo.vespa.model.container.amender") || cf.getListenPort() == Container.BASEPORT && cf.sslProvider() instanceof DefaultSslProvider;
    }
}

