/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import com.yahoo.vespa.model.container.http.ssl.SslProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ConnectorFactory
extends SimpleComponent
implements ConnectorConfig.Producer {
    private final String name;
    private final int listenPort;
    private final SslProvider sslProviderComponent;
    private volatile ComponentId defaultRequestFilterChain;
    private volatile ComponentId defaultResponseFilterChain;
    private final Set<AccessLogComponent.RequestContentItem> requestContentLogging = new HashSet<AccessLogComponent.RequestContentItem>();

    protected ConnectorFactory(Builder builder) {
        super(new ComponentModel(builder.name, com.yahoo.jdisc.http.server.jetty.ConnectorFactory.class.getName(), null));
        this.name = builder.name;
        this.listenPort = builder.listenPort;
        this.sslProviderComponent = builder.sslProvider != null ? builder.sslProvider : new DefaultSslProvider(this.name);
        this.defaultRequestFilterChain = builder.defaultRequestFilterChain;
        this.defaultResponseFilterChain = builder.defaultResponseFilterChain;
        this.addChild(this.sslProviderComponent);
        this.inject(this.sslProviderComponent);
    }

    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        connectorBuilder.listenPort(this.listenPort);
        connectorBuilder.name(this.name);
        connectorBuilder.accessLog(new ConnectorConfig.AccessLog.Builder().remoteAddressHeaders(List.of("x-forwarded-for")).remotePortHeaders(List.of("X-Forwarded-Port")).content(this.requestContentLogging.stream().map(item -> new ConnectorConfig.AccessLog.Content.Builder().sampleRate(item.samplesPerSecond()).pathPrefix(item.pathPrefix()).maxSize((long)item.maxBytes())).toList()));
        this.sslProviderComponent.amendConnectorConfig(connectorBuilder);
    }

    public String getName() {
        return this.name;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public Optional<ComponentId> getDefaultRequestFilterChain() {
        return Optional.ofNullable(this.defaultRequestFilterChain);
    }

    public Optional<ComponentId> getDefaultResponseFilterChain() {
        return Optional.ofNullable(this.defaultResponseFilterChain);
    }

    public void setDefaultRequestFilterChain(ComponentId filterChain) {
        this.defaultRequestFilterChain = filterChain;
    }

    public void setDefaultResponseFilterChain(ComponentId filterChain) {
        this.defaultResponseFilterChain = filterChain;
    }

    public void addRequestContentLogging(Set<AccessLogComponent.RequestContentItem> requestContent) {
        this.requestContentLogging.addAll(requestContent);
    }

    public SslProvider sslProvider() {
        return this.sslProviderComponent;
    }

    public static class Builder {
        private final String name;
        private final int listenPort;
        private SslProvider sslProvider;
        private ComponentId defaultRequestFilterChain;
        private ComponentId defaultResponseFilterChain;

        public Builder(String name, int listenPort) {
            this.name = name;
            this.listenPort = listenPort;
        }

        public Builder sslProvider(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
            return this;
        }

        public Builder defaultRequestFilterChain(ComponentId filterChain) {
            this.defaultRequestFilterChain = filterChain;
            return this;
        }

        public Builder defaultResponseFilterChain(ComponentId filterChain) {
            this.defaultResponseFilterChain = filterChain;
            return this;
        }

        public ConnectorFactory build() {
            return new ConnectorFactory(this);
        }
    }
}

