/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.schema.Index;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.MatchAlgorithm;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.Map;

public class NoPrefixForIndexes
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        for (SearchCluster cluster : context.model().getSearchClusters()) {
            for (SchemaInfo schemaInfo : cluster.schemas().values()) {
                if (schemaInfo.getIndexMode() != SchemaInfo.IndexMode.INDEX) continue;
                Schema schema = schemaInfo.fullSchema();
                for (ImmutableSDField immutableSDField : schema.allConcreteFields()) {
                    if (!immutableSDField.doesIndexing()) continue;
                    if (immutableSDField.getMatching().getAlgorithm().equals((Object)MatchAlgorithm.PREFIX)) {
                        this.failField(context, schema, immutableSDField);
                    }
                    for (Map.Entry<String, Index> e : immutableSDField.getIndices().entrySet()) {
                        if (!e.getValue().isPrefix()) continue;
                        this.failField(context, schema, immutableSDField);
                    }
                }
            }
        }
    }

    private void failField(Validation.Context context, Schema schema, ImmutableSDField field) {
        context.illegal("For " + String.valueOf(schema) + ", field '" + field.getName() + "': match/index:prefix is not supported for indexes.");
    }
}

