/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.Schema;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class DocumentSummary {
    private final String name;
    private final Map<String, SummaryField> fields = new LinkedHashMap<String, SummaryField>();
    private boolean fromDisk = false;
    private boolean omitSummaryFeatures = false;
    private final List<String> inherited = new ArrayList<String>();
    private final Schema owner;

    public DocumentSummary(String name, Schema owner) {
        this.name = name;
        this.owner = owner;
    }

    public String name() {
        return this.name;
    }

    public Schema owner() {
        return this.owner;
    }

    public Collection<SummaryField> values() {
        return this.fields.values();
    }

    public SummaryField get(String name) {
        return this.fields.get(name);
    }

    public void remove(String name) {
        this.fields.remove(name);
    }

    public DocumentSummary add(SummaryField field) {
        field.addDestination(this.name());
        if (this.fields.containsKey(field.getName())) {
            if (!this.fields.get(field.getName()).equals(field)) {
                throw new IllegalArgumentException("Duplicate declaration of " + String.valueOf(field) + " in " + String.valueOf(this));
            }
        } else {
            this.fields.put(field.getName(), field);
        }
        return this;
    }

    public DocumentSummary add(DocumentSummary other) {
        for (SummaryField field : other.values()) {
            this.add(field);
        }
        return this;
    }

    public void setFromDisk(boolean fromDisk) {
        this.fromDisk = fromDisk;
    }

    public boolean isFromDisk() {
        return this.fromDisk;
    }

    public void setOmitSummaryFeatures(boolean value) {
        this.omitSummaryFeatures = value;
    }

    public boolean omitSummaryFeatures() {
        return this.omitSummaryFeatures;
    }

    public SummaryField getSummaryField(String name) {
        SummaryField field = this.get(name);
        if (field != null) {
            return field;
        }
        if (this.inherited().isEmpty()) {
            return null;
        }
        for (DocumentSummary inheritedSummary : this.inherited()) {
            SummaryField inheritedField = inheritedSummary.getSummaryField(name);
            if (inheritedField == null) continue;
            return inheritedField;
        }
        return null;
    }

    public Map<String, SummaryField> getSummaryFields() {
        LinkedHashMap<String, SummaryField> allFields = new LinkedHashMap<String, SummaryField>(this.values().size());
        for (DocumentSummary inheritedSummary : this.inherited()) {
            if (inheritedSummary == null) continue;
            allFields.putAll(inheritedSummary.getSummaryFields());
        }
        for (SummaryField field : this.values()) {
            allFields.put(field.getName(), field);
        }
        return allFields;
    }

    public void purgeImplicits() {
        ArrayList<SummaryField> falseImplicits = new ArrayList<SummaryField>();
        for (SummaryField summaryField : this.getSummaryFields().values()) {
            if (summaryField.isImplicit()) continue;
            Iterator<SummaryField.Source> j = summaryField.sourceIterator();
            while (j.hasNext()) {
                SummaryField sourceField;
                String sourceName = j.next().getName();
                if (sourceName.equals(summaryField.getName()) || (sourceField = this.getSummaryField(sourceName)) == null || !sourceField.isImplicit()) continue;
                falseImplicits.add(sourceField);
            }
        }
        for (SummaryField field : falseImplicits) {
            this.remove(field.getName());
        }
    }

    public void addInherited(String inherited) {
        this.inherited.add(inherited);
    }

    public List<DocumentSummary> inherited() {
        return this.inherited.stream().map(this.owner::getSummary).toList();
    }

    public String toString() {
        return "document-summary '" + this.name() + "' in " + String.valueOf(this.owner);
    }

    public void validate(DeployLogger logger) {
        for (String inheritedName : this.inherited) {
            DocumentSummary inheritedSummary = this.owner.getSummary(inheritedName);
            if (inheritedName.equals("default")) {
                logger.logApplicationPackage(Level.WARNING, String.valueOf(this) + " inherits '" + inheritedName + "', which makes no sense. Remove this inheritance");
                continue;
            }
            if (inheritedSummary != null) continue;
            throw new IllegalArgumentException(String.valueOf(this) + " inherits '" + inheritedName + "', but this is not present in " + String.valueOf(this.owner));
        }
    }
}

