/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class HnswValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        Set<ContentCluster> clusters = HnswValidator.clustersWithMoreThanOneSearchableCopy(context);
        if (clusters.isEmpty()) {
            return;
        }
        clusters.forEach(contentCluster -> HnswValidator.validateCluster(context, contentCluster));
    }

    private static void validateCluster(Validation.Context context, ContentCluster cluster) {
        if (!cluster.getSearch().hasSearchCluster()) {
            return;
        }
        for (SchemaInfo schema : cluster.getSearch().getSearchCluster().schemas().values()) {
            if (!HnswValidator.warnAboutSearchableCopies(schema)) continue;
            String message = "Cluster '%s' has searchable copies > 1 and fields with hnsw index. This will use a lot of resources, consider using searchable-copies=1%s".formatted(cluster.getName(), cluster.getSearch().usesHierarchicDistribution() ? "" : " and going to a grouped setup, see https://docs.vespa.ai/en/elasticity.html#grouped-distribution");
            context.deployState().getDeployLogger().logApplicationPackage(Level.WARNING, message);
        }
    }

    private static boolean warnAboutSearchableCopies(SchemaInfo schema) {
        return schema.fullSchema().allFields().mapToLong(field -> HnswValidator.hnswAttributes(field).size()).sum() > 0L;
    }

    private static Set<ContentCluster> clustersWithMoreThanOneSearchableCopy(Validation.Context context) {
        return context.model().getContentClusters().values().stream().filter(c -> c.getRedundancy().readyCopies() > 1).collect(Collectors.toSet());
    }

    private static Set<Attribute> hnswAttributes(ImmutableSDField field) {
        return field.getAttributes().values().stream().filter(a -> a.hnswIndexParams().isPresent()).collect(Collectors.toSet());
    }
}

