/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.documentmodel.NewDocumentType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReservedDocumentTypeNameValidator {
    public static final List<String> ORDERED_RESERVED_NAMES = List.of("and", "false", "id", "not", "null", "or", "true");
    public static final Set<String> RESERVED_NAMES = Set.copyOf(ORDERED_RESERVED_NAMES);

    public void validate(Map<String, NewDocumentType> documentDefinitions) {
        List<String> conflictingNames = documentDefinitions.keySet().stream().filter(this::isReservedName).toList();
        if (!conflictingNames.isEmpty()) {
            throw new IllegalArgumentException(ReservedDocumentTypeNameValidator.makeReservedNameMessage(conflictingNames));
        }
    }

    private boolean isReservedName(String name) {
        return RESERVED_NAMES.contains(name.toLowerCase());
    }

    private static String asQuotedListString(List<String> list) {
        return list.stream().map(s -> String.format("'%s'", s)).collect(Collectors.joining(", "));
    }

    private static String makeReservedNameMessage(List<String> conflictingNames) {
        return String.format("The following document types conflict with reserved keyword names: %s. Reserved keywords are %s", ReservedDocumentTypeNameValidator.asQuotedListString(conflictingNames), ReservedDocumentTypeNameValidator.asQuotedListString(ORDERED_RESERVED_NAMES));
    }
}

